package com.xforceplus.ultraman.app.jcrichemont.controller;


/**
 * 结算单明细表feign客户端
 *
 * @author ultraman
 * @date 2024-07-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcrichemont.entity.SettlementDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-richemont")
public interface SettlementDetailFeignApi {

  /**
   * 通过id查询结算单明细表
   * @param  id
   * @return R
   */
  @GetMapping("/settlementDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增结算单明细表
   * @param settlementDetail 结算单明细表
   * @return R
   */
  @PostMapping("/settlementDetail/add")
  public R save(@RequestBody SettlementDetail settlementDetail);

  /**
   * 修改结算单明细表
   * @param settlementDetail 结算单明细表
   * @return R
   */
  @PostMapping("/settlementDetail/update")
  public R updateById(@RequestBody SettlementDetail settlementDetail);

  /**
   * 通过id删除结算单明细表
   * @param  id
   * @return R
   */
  @DeleteMapping("/settlementDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}