package com.xforceplus.ultraman.app.jcrichemont.controller;


/**
 * 结算单流水表feign客户端
 *
 * @author ultraman
 * @date 2024-07-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcrichemont.entity.SettlementNode;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-richemont")
public interface SettlementNodeFeignApi {

  /**
   * 通过id查询结算单流水表
   * @param  id
   * @return R
   */
  @GetMapping("/settlementNode/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增结算单流水表
   * @param settlementNode 结算单流水表
   * @return R
   */
  @PostMapping("/settlementNode/add")
  public R save(@RequestBody SettlementNode settlementNode);

  /**
   * 修改结算单流水表
   * @param settlementNode 结算单流水表
   * @return R
   */
  @PostMapping("/settlementNode/update")
  public R updateById(@RequestBody SettlementNode settlementNode);

  /**
   * 通过id删除结算单流水表
   * @param  id
   * @return R
   */
  @DeleteMapping("/settlementNode/del/{id}" )
  public R removeById(@PathVariable Long id);

}