package com.xforceplus.ultraman.app.jcrichemont.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-05-20
 */
public enum InvoiceFlag {

    Z("z", "是"),
    NONE("none", "否");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceFlag fromCode(String code){
        switch(code) {
            case "z":
                return Z;
            case "none":
                return NONE;
            default:
                return null;
        }
    }
}
