package com.xforceplus.ultraman.app.jcrichemont.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_type
 * </p>
 *
 * @author ultraman
 * @since 2024-05-20
 */
public enum InvoiceType {

    CE("ce", "电票"),
    C("c", "普票"),
    S("s", "专票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "ce":
                return CE;
            case "c":
                return C;
            case "s":
                return S;
            default:
                return null;
        }
    }
}
