package com.xforceplus.ultraman.app.jcrichemont.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 订单明细表
 * </p>
 *
 * @author ultraman
 * @since 2024-05-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderInfoDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 订单明细行号
   */
  private String orderItemNo;

  /**
   * 订单主表唯一号
   */
  private String orderInfoNo;

  /**
   * 商品描述
   */
  private String itemName;

  /**
   * 规格
   */
  private String itemSpec;

  /**
   * 数量
   */
  private BigDecimal quantity;

  /**
   * 数量单位
   */
  private String quantityUnit;

  /**
   * 单价
   */
  private BigDecimal unitPrice;

  /**
   * 已分摊折扣
   */
  private BigDecimal outerDiscountWithTax;

  /**
   * 商品编码
   */
  private String volunCode;

  /**
   * 可开含税金额
   */
  private BigDecimal amountWithTax;

  /**
   * 税率
   */
  private String taxRate;

  /**
   * 商品税编
   */
  private String itemCode;

  /**
   * 是否享受税收优惠
   */
  private String taxPre;

  /**
   * 税收优惠
   */
  private String taxPreCon;

  /**
   * 是否零税率
   */
  private String zeroTax;

  /**
   * 成品油标示
   */
  private String oilFlag;

  /**
   * 开票标示
   */
  private String legalInvoiceFlag;

  /**
   * 开票区分
   */
  private String invoiceStatus;

  /**
   * 开票标记
   */
  private String fdFlag;

  /**
   * 退货区分
   */
  private String returnFlg;

  /**
   * 含税折扣金额
   */
  private BigDecimal totalDiscountAmount;

  /**
   * 折扣后税额
   */
  private BigDecimal vatAmount;

  /**
   * 折扣后含税单价
   */
  private BigDecimal totalPrice;

  /**
   * 单个商品折扣后不含税总金额
   */
  private BigDecimal itemTotalNetAmount;

  /**
   * 商品组
   */
  private String itemGroup;

  /**
   * 税编简称
   */
  private String taxCodeAbbr;

  /**
   * 退货标记
   */
  private String returnFlag;

  /**
   * 发票标记
   */
  private String invoiceFlag;

  /**
   * 订单类型
   */
  private String orderType;

  /**
   * 结算单号
   */
  private String posNo;

  /**
   * 订单id
   */
  private String orderId;

  /**
   * 赠品标志
   */
  private String isGiftFlag;

  /**
   * 是否有赠品
   */
  private String hasGiftFlag;

  /**
   * 赠品对应的正品明细号
   */
  private String giftToGoodsNo;

  /**
   * 结算单含税金额
   */
  private BigDecimal settlementAmountWithTax;

  /**
   * 结算单不函税金额
   */
  private BigDecimal settlementOuterDiscountWithTax;

  /**
   * 退货单号
   */
  private String returnPosNo;

  /**
   * 结算单数量
   */
  private BigDecimal settlementQuantity;

  /**
   * 历峰订单 扩展标记
   */
  private String richemontOrderExtendFlag;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("order_item_no", orderItemNo);
      map.put("order_info_no", orderInfoNo);
      map.put("item_name", itemName);
      map.put("item_spec", itemSpec);
      map.put("quantity", quantity);
      map.put("quantity_unit", quantityUnit);
      map.put("unit_price", unitPrice);
      map.put("outer_discount_with_tax", outerDiscountWithTax);
      map.put("volun_code", volunCode);
      map.put("amount_with_tax", amountWithTax);
      map.put("tax_rate", taxRate);
      map.put("item_code", itemCode);
      map.put("tax_pre", taxPre);
      map.put("tax_pre_con", taxPreCon);
      map.put("zero_tax", zeroTax);
      map.put("oil_flag", oilFlag);
      map.put("legal_invoice_flag", legalInvoiceFlag);
      map.put("invoice_status", invoiceStatus);
      map.put("fd_flag", fdFlag);
      map.put("return_flg", returnFlg);
      map.put("total_discount_amount", totalDiscountAmount);
      map.put("vat_amount", vatAmount);
      map.put("total_price", totalPrice);
      map.put("item_total_net_amount", itemTotalNetAmount);
      map.put("item_group", itemGroup);
      map.put("tax_code_abbr", taxCodeAbbr);
      map.put("return_flag", returnFlag);
      map.put("invoice_flag", invoiceFlag);
      map.put("order_type", orderType);
      map.put("pos_no", posNo);
      map.put("order_id", orderId);
      map.put("is_gift_flag", isGiftFlag);
      map.put("has_gift_flag", hasGiftFlag);
      map.put("gift_to_goods_no", giftToGoodsNo);
      map.put("settlement_amount_with_tax", settlementAmountWithTax);
      map.put("settlement_outer_discount_with_tax", settlementOuterDiscountWithTax);
      map.put("return_pos_no", returnPosNo);
      map.put("settlement_quantity", settlementQuantity);
      map.put("richemont_order_extend_flag", richemontOrderExtendFlag);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static OrderInfoDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OrderInfoDetail entity = new OrderInfoDetail();
    if(map.containsKey("order_item_no")) {
      Object obj = map.get("order_item_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_info_no")) {
      Object obj = map.get("order_info_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderInfoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_spec")) {
      Object obj = map.get("item_spec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantity_unit")) {
      Object obj = map.get("quantity_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit_price")) {
      Object obj = map.get("unit_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outer_discount_with_tax")) {
      Object obj = map.get("outer_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("volun_code")) {
      Object obj = map.get("volun_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVolunCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_code")) {
      Object obj = map.get("item_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_pre")) {
      Object obj = map.get("tax_pre");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPre((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_pre_con")) {
      Object obj = map.get("tax_pre_con");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPreCon((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zero_tax")) {
      Object obj = map.get("zero_tax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZeroTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oil_flag")) {
      Object obj = map.get("oil_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOilFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("legal_invoice_flag")) {
      Object obj = map.get("legal_invoice_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLegalInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fd_flag")) {
      Object obj = map.get("fd_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFdFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_flg")) {
      Object obj = map.get("return_flg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnFlg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("total_discount_amount")) {
      Object obj = map.get("total_discount_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalDiscountAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalDiscountAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalDiscountAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalDiscountAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalDiscountAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("vat_amount")) {
      Object obj = map.get("vat_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setVatAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setVatAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setVatAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVatAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVatAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_price")) {
      Object obj = map.get("total_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("item_total_net_amount")) {
      Object obj = map.get("item_total_net_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setItemTotalNetAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setItemTotalNetAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setItemTotalNetAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setItemTotalNetAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setItemTotalNetAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("item_group")) {
      Object obj = map.get("item_group");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_code_abbr")) {
      Object obj = map.get("tax_code_abbr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxCodeAbbr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_flag")) {
      Object obj = map.get("return_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_flag")) {
      Object obj = map.get("invoice_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pos_no")) {
      Object obj = map.get("pos_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPosNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_gift_flag")) {
      Object obj = map.get("is_gift_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsGiftFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("has_gift_flag")) {
      Object obj = map.get("has_gift_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHasGiftFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gift_to_goods_no")) {
      Object obj = map.get("gift_to_goods_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGiftToGoodsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_amount_with_tax")) {
      Object obj = map.get("settlement_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlement_outer_discount_with_tax")) {
      Object obj = map.get("settlement_outer_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("return_pos_no")) {
      Object obj = map.get("return_pos_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnPosNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_quantity")) {
      Object obj = map.get("settlement_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("richemont_order_extend_flag")) {
      Object obj = map.get("richemont_order_extend_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRichemontOrderExtendFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("order_item_no")) {
      Object obj = map.get("order_item_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderItemNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_info_no")) {
      Object obj = map.get("order_info_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderInfoNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_spec")) {
      Object obj = map.get("item_spec");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemSpec((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("quantity_unit")) {
      Object obj = map.get("quantity_unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQuantityUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unit_price")) {
      Object obj = map.get("unit_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outer_discount_with_tax")) {
      Object obj = map.get("outer_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("volun_code")) {
      Object obj = map.get("volun_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVolunCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_code")) {
      Object obj = map.get("item_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_pre")) {
      Object obj = map.get("tax_pre");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPre((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_pre_con")) {
      Object obj = map.get("tax_pre_con");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPreCon((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zero_tax")) {
      Object obj = map.get("zero_tax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZeroTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("oil_flag")) {
      Object obj = map.get("oil_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOilFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("legal_invoice_flag")) {
      Object obj = map.get("legal_invoice_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLegalInvoiceFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fd_flag")) {
      Object obj = map.get("fd_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFdFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("return_flg")) {
      Object obj = map.get("return_flg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnFlg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("total_discount_amount")) {
      Object obj = map.get("total_discount_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalDiscountAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalDiscountAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalDiscountAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalDiscountAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalDiscountAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("vat_amount")) {
      Object obj = map.get("vat_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setVatAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setVatAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setVatAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVatAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setVatAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("total_price")) {
      Object obj = map.get("total_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("item_total_net_amount")) {
      Object obj = map.get("item_total_net_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setItemTotalNetAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setItemTotalNetAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setItemTotalNetAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setItemTotalNetAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setItemTotalNetAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("item_group")) {
      Object obj = map.get("item_group");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_code_abbr")) {
      Object obj = map.get("tax_code_abbr");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxCodeAbbr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("return_flag")) {
      Object obj = map.get("return_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_flag")) {
      Object obj = map.get("invoice_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pos_no")) {
      Object obj = map.get("pos_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPosNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_gift_flag")) {
      Object obj = map.get("is_gift_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsGiftFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("has_gift_flag")) {
      Object obj = map.get("has_gift_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHasGiftFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gift_to_goods_no")) {
      Object obj = map.get("gift_to_goods_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGiftToGoodsNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlement_amount_with_tax")) {
      Object obj = map.get("settlement_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSettlementAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSettlementAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSettlementAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSettlementAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("settlement_outer_discount_with_tax")) {
      Object obj = map.get("settlement_outer_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSettlementOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSettlementOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSettlementOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSettlementOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("return_pos_no")) {
      Object obj = map.get("return_pos_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnPosNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlement_quantity")) {
      Object obj = map.get("settlement_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSettlementQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSettlementQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSettlementQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSettlementQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("richemont_order_extend_flag")) {
      Object obj = map.get("richemont_order_extend_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRichemontOrderExtendFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
