package com.xforceplus.ultraman.app.jcrichemont.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 订单主表
 * </p>
 *
 * @author ultraman
 * @since 2024-05-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderInfoMain implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 订单状态
   */
  private String orderStatus;

  /**
   * 开票状态
   */
  private String invoiceStatus;

  /**
   * 门店编号
   */
  private String storeCode;

  /**
   * 组合订单号
   */
  private String posNo;

  /**
   * 原发票含税金额
   */
  private BigDecimal amountWithTax;

  /**
   * 需分摊折扣金额
   */
  private BigDecimal outerDiscountWithTax;

  /**
   * mi账号
   */
  private String miAccount;

  /**
   * 备注
   */
  private String remark;

  /**
   * 收款人姓名
   */
  private String cashierName;

  /**
   * 复核人姓名
   */
  private String checkerName;

  /**
   * 开票人姓名
   */
  private String invoicerName;

  /**
   * 原发票号码
   */
  private String originInvoiceNo;

  /**
   * 原发票代码
   */
  private String originInvoiceCode;

  /**
   * 业务单据类型
   */
  private String businessBillType;

  /**
   * 操作类型
   */
  private String status;

  /**
   * 支付类型
   */
  private String payType;

  /**
   * 会员号
   */
  private String customerId;

  /**
   * 顾客名称
   */
  private String custName;

  /**
   * 顾客公司类型
   */
  private String custCompanyType;

  /**
   * 门牌号
   */
  private String custAddressBuildingName;

  /**
   * 电话
   */
  private String custPhoneNumber;

  /**
   * 城市名称
   */
  private String custAddressCityName;

  /**
   * 街道地址
   */
  private String custAddressStreetName;

  /**
   * 顾客编号
   */
  private String custNumber;

  /**
   * 银行卡号
   */
  private String kcpoFiscalId;

  /**
   * 顾客所属银行名称
   */
  private String kcpoPurposedEscription;

  /**
   * 购买方税号
   */
  private String taxCode;

  /**
   * 顾客开票类型
   */
  private String custInvoiceTypeCode;

  /**
   * 饿了么等电商的编码
   */
  private String codCode;

  /**
   * 注释
   */
  private String comment;

  /**
   * 持卡人姓
   */
  private String cardHolderLastName;

  /**
   * 持卡人名
   */
  private String cardHolderFirstName;

  /**
   * 订单号
   */
  private String orderNo;

  /**
   * 结算单号
   */
  private String settlementNo;

  /**
   * 发票操作版本
   */
  private String invoiceOperationVersion;

  /**
   * 开票标示
   */
  private String legalInvoiceFlag;

  /**
   * 历峰订单号
   */
  private String orderInfoNo;

  /**
   * 组标记
   */
  private String groupFlag;

  /**
   * 销方信息
   */
  private String sellerInfoFill;

  /**
   * 购方信息
   */
  private String purchaserInfoFill;

  /**
   * 销方税号
   */
  private String sellerTaxNo;

  /**
   * 销方名称
   */
  private String sellerName;

  /**
   * 退货标记
   */
  private String returnFlg;

  /**
   * 读标记
   */
  private String readFlg;

  /**
   * 发票总金额
   */
  private BigDecimal invoiceTotalAmount;

  /**
   * 发票总税额
   */
  private BigDecimal invoiceTotalTax;

  /**
   * 下单时间
   */
  private String posTime;

  /**
   * 发票总最高支付金额
   */
  private BigDecimal invoiceTotalTopPayAmount;

  /**
   * 发票总行li
   */
  private BigDecimal invoiceTotalColLi;

  /**
   * 邮件地址
   */
  private String mailAddress;

  /**
   * 订单含税金额
   */
  private BigDecimal orderWithTaxesTotalAmount;

  /**
   * 订单含税折扣金额
   */
  private BigDecimal orderWithTaxesTotalDiscountAmount;

  /**
   * 查询id
   */
  private String searchId;

  /**
   * 订单总数量
   */
  private Long orderTotalCount;

  /**
   * 订单总qty数量
   */
  private BigDecimal orderTotalQtyCount;

  /**
   * 订单总金额
   */
  private BigDecimal orderTotalAmount;

  /**
   * 订单总税额
   */
  private BigDecimal orderTotalTax;

  /**
   * 加入字符
   */
  private String joinchar;

  /**
   * 订单id
   */
  private String orderId;

  /**
   * 品牌
   */
  private String brand;

  /**
   * 精品店代码
   */
  private String boutiqueCode;

  /**
   * 精品店国家
   */
  private String boutiqueCountry;

  /**
   * 购方税号
   */
  private String purchaserTaxNo;

  /**
   * 购方名称
   */
  private String purchaserName;

  /**
   * 购方地址
   */
  private String purchaserAddr;

  /**
   * 购方电话
   */
  private String purchaserTel;

  /**
   * 购方银行信息
   */
  private String purchaserBankInfo;

  /**
   * 购方银行账号
   */
  private String purchaserBankAccount;

  /**
   * 实际发票含税金额
   */
  private BigDecimal actualInvoiceAmountWithTax;

  /**
   * 实际发票不含税金额
   */
  private BigDecimal actualInvoiceOuterDiscountWithTax;

  /**
   * 历峰订单扩展标记
   */
  private String richemontOrderExtendFlag;

  /**
   * 支付金额
   */
  private BigDecimal payAmount;

  /**
   * 二维码过期天数
   */
  private Long qrcodeExpireDay;

  /**
   * 门店名称
   */
  private String storeName;

  /**
   * 结算单含税金额
   */
  private BigDecimal settlementAmountWithTax;

  /**
   * 退货单号
   */
  private String returnPosNo;

  /**
   * 发票代码
   */
  private String invoiceCode;

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * 重开发票
   */
  private String reopenInvoice;

  /**
   * 客户代码
   */
  private String customerCode;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 订单日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime posDate;

  /**
   * 是否已开票
   */
  private String invoiceFlag;

  /**
   * 订单类型
   */
  private String orderType;

  /**
   * 发票类型
   */
  private String invoiceType;

  /**
   * 电子邮件
   */
  private String email;


  /**
   * 对一关联关系 关联对象 storeInfo
   */
    private Long orderAndStoreRelationshipId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("order_status", orderStatus);
      map.put("invoice_status", invoiceStatus);
      map.put("store_code", storeCode);
      map.put("pos_no", posNo);
      map.put("amount_with_tax", amountWithTax);
      map.put("outer_discount_with_tax", outerDiscountWithTax);
      map.put("mi_account", miAccount);
      map.put("remark", remark);
      map.put("cashier_name", cashierName);
      map.put("checker_name", checkerName);
      map.put("invoicer_name", invoicerName);
      map.put("origin_invoice_no", originInvoiceNo);
      map.put("origin_invoice_code", originInvoiceCode);
      map.put("business_bill_type", businessBillType);
      map.put("status", status);
      map.put("pay_type", payType);
      map.put("customer_id", customerId);
      map.put("cust_name", custName);
      map.put("cust_company_type", custCompanyType);
      map.put("cust_address_building_name", custAddressBuildingName);
      map.put("cust_phone_number", custPhoneNumber);
      map.put("cust_address_city_name", custAddressCityName);
      map.put("cust_address_street_name", custAddressStreetName);
      map.put("cust_number", custNumber);
      map.put("kcpo_fiscal_id", kcpoFiscalId);
      map.put("kcpo_purposed_escription", kcpoPurposedEscription);
      map.put("tax_code", taxCode);
      map.put("cust_invoice_type_code", custInvoiceTypeCode);
      map.put("cod_code", codCode);
      map.put("comment", comment);
      map.put("card_holder_last_name", cardHolderLastName);
      map.put("card_holder_first_name", cardHolderFirstName);
      map.put("order_no", orderNo);
      map.put("settlement_no", settlementNo);
      map.put("invoice_operation_version", invoiceOperationVersion);
      map.put("legal_invoice_flag", legalInvoiceFlag);
      map.put("order_info_no", orderInfoNo);
      map.put("group_flag", groupFlag);
      map.put("seller_info_fill", sellerInfoFill);
      map.put("purchaser_info_fill", purchaserInfoFill);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("seller_name", sellerName);
      map.put("return_flg", returnFlg);
      map.put("read_flg", readFlg);
      map.put("invoice_total_amount", invoiceTotalAmount);
      map.put("invoice_total_tax", invoiceTotalTax);
      map.put("pos_time", posTime);
      map.put("invoice_total_top_pay_amount", invoiceTotalTopPayAmount);
      map.put("invoice_total_col_li", invoiceTotalColLi);
      map.put("mail_address", mailAddress);
      map.put("order_with_taxes_total_amount", orderWithTaxesTotalAmount);
      map.put("order_with_taxes_total_discount_amount", orderWithTaxesTotalDiscountAmount);
      map.put("search_id", searchId);
      map.put("order_total_count", orderTotalCount);
      map.put("order_total_qty_count", orderTotalQtyCount);
      map.put("order_total_amount", orderTotalAmount);
      map.put("order_total_tax", orderTotalTax);
      map.put("joinchar", joinchar);
      map.put("order_id", orderId);
      map.put("brand", brand);
      map.put("boutique_code", boutiqueCode);
      map.put("boutique_country", boutiqueCountry);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("purchaser_name", purchaserName);
      map.put("purchaser_addr", purchaserAddr);
      map.put("purchaser_tel", purchaserTel);
      map.put("purchaser_bank_info", purchaserBankInfo);
      map.put("purchaser_bank_account", purchaserBankAccount);
      map.put("actual_invoice_amount_with_tax", actualInvoiceAmountWithTax);
      map.put("actual_invoice_outer_discount_with_tax", actualInvoiceOuterDiscountWithTax);
      map.put("richemont_order_extend_flag", richemontOrderExtendFlag);
      map.put("pay_amount", payAmount);
      map.put("qrcode_expire_day", qrcodeExpireDay);
      map.put("store_name", storeName);
      map.put("settlement_amount_with_tax", settlementAmountWithTax);
      map.put("return_pos_no", returnPosNo);
      map.put("invoice_code", invoiceCode);
      map.put("invoice_no", invoiceNo);
      map.put("reopen_invoice", reopenInvoice);
      map.put("customer_code", customerCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("pos_date", BocpGenUtils.toTimestamp(posDate));
      map.put("invoice_flag", invoiceFlag);
      map.put("order_type", orderType);
      map.put("invoice_type", invoiceType);
      map.put("email", email);

       map.put("orderAndStoreRelationship.id", orderAndStoreRelationshipId);
      return map;
  }

  public static OrderInfoMain fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OrderInfoMain entity = new OrderInfoMain();
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_code")) {
      Object obj = map.get("store_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pos_no")) {
      Object obj = map.get("pos_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPosNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outer_discount_with_tax")) {
      Object obj = map.get("outer_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("mi_account")) {
      Object obj = map.get("mi_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMiAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashier_name")) {
      Object obj = map.get("cashier_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicer_name")) {
      Object obj = map.get("invoicer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_bill_type")) {
      Object obj = map.get("business_bill_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_id")) {
      Object obj = map.get("customer_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cust_name")) {
      Object obj = map.get("cust_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cust_company_type")) {
      Object obj = map.get("cust_company_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustCompanyType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cust_address_building_name")) {
      Object obj = map.get("cust_address_building_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustAddressBuildingName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cust_phone_number")) {
      Object obj = map.get("cust_phone_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustPhoneNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cust_address_city_name")) {
      Object obj = map.get("cust_address_city_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustAddressCityName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cust_address_street_name")) {
      Object obj = map.get("cust_address_street_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustAddressStreetName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cust_number")) {
      Object obj = map.get("cust_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kcpo_fiscal_id")) {
      Object obj = map.get("kcpo_fiscal_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKcpoFiscalId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kcpo_purposed_escription")) {
      Object obj = map.get("kcpo_purposed_escription");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKcpoPurposedEscription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_code")) {
      Object obj = map.get("tax_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cust_invoice_type_code")) {
      Object obj = map.get("cust_invoice_type_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustInvoiceTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cod_code")) {
      Object obj = map.get("cod_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCodCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("comment")) {
      Object obj = map.get("comment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setComment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("card_holder_last_name")) {
      Object obj = map.get("card_holder_last_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCardHolderLastName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("card_holder_first_name")) {
      Object obj = map.get("card_holder_first_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCardHolderFirstName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_operation_version")) {
      Object obj = map.get("invoice_operation_version");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceOperationVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("legal_invoice_flag")) {
      Object obj = map.get("legal_invoice_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLegalInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_info_no")) {
      Object obj = map.get("order_info_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderInfoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("group_flag")) {
      Object obj = map.get("group_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGroupFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_info_fill")) {
      Object obj = map.get("seller_info_fill");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerInfoFill((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_info_fill")) {
      Object obj = map.get("purchaser_info_fill");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserInfoFill((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_flg")) {
      Object obj = map.get("return_flg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnFlg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("read_flg")) {
      Object obj = map.get("read_flg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReadFlg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_total_amount")) {
      Object obj = map.get("invoice_total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_total_tax")) {
      Object obj = map.get("invoice_total_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceTotalTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceTotalTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceTotalTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceTotalTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceTotalTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("pos_time")) {
      Object obj = map.get("pos_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPosTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_total_top_pay_amount")) {
      Object obj = map.get("invoice_total_top_pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceTotalTopPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceTotalTopPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceTotalTopPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceTotalTopPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceTotalTopPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_total_col_li")) {
      Object obj = map.get("invoice_total_col_li");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceTotalColLi((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceTotalColLi(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceTotalColLi(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceTotalColLi(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceTotalColLi(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("mail_address")) {
      Object obj = map.get("mail_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMailAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_with_taxes_total_amount")) {
      Object obj = map.get("order_with_taxes_total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderWithTaxesTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderWithTaxesTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderWithTaxesTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderWithTaxesTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderWithTaxesTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("order_with_taxes_total_discount_amount")) {
      Object obj = map.get("order_with_taxes_total_discount_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderWithTaxesTotalDiscountAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderWithTaxesTotalDiscountAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderWithTaxesTotalDiscountAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderWithTaxesTotalDiscountAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderWithTaxesTotalDiscountAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("search_id")) {
      Object obj = map.get("search_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSearchId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_total_count")) {
      Object obj = map.get("order_total_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderTotalCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderTotalCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderTotalCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("order_total_qty_count")) {
      Object obj = map.get("order_total_qty_count");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderTotalQtyCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderTotalQtyCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderTotalQtyCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderTotalQtyCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderTotalQtyCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("order_total_amount")) {
      Object obj = map.get("order_total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("order_total_tax")) {
      Object obj = map.get("order_total_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderTotalTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderTotalTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderTotalTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderTotalTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderTotalTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("joinchar")) {
      Object obj = map.get("joinchar");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJoinchar((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("boutique_code")) {
      Object obj = map.get("boutique_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBoutiqueCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("boutique_country")) {
      Object obj = map.get("boutique_country");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBoutiqueCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_addr")) {
      Object obj = map.get("purchaser_addr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_info")) {
      Object obj = map.get("purchaser_bank_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("actual_invoice_amount_with_tax")) {
      Object obj = map.get("actual_invoice_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setActualInvoiceAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setActualInvoiceAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setActualInvoiceAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActualInvoiceAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActualInvoiceAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("actual_invoice_outer_discount_with_tax")) {
      Object obj = map.get("actual_invoice_outer_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setActualInvoiceOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setActualInvoiceOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setActualInvoiceOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActualInvoiceOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActualInvoiceOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("richemont_order_extend_flag")) {
      Object obj = map.get("richemont_order_extend_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRichemontOrderExtendFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("qrcode_expire_day")) {
      Object obj = map.get("qrcode_expire_day");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setQrcodeExpireDay((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQrcodeExpireDay(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQrcodeExpireDay(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("store_name")) {
      Object obj = map.get("store_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_amount_with_tax")) {
      Object obj = map.get("settlement_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("return_pos_no")) {
      Object obj = map.get("return_pos_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnPosNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reopen_invoice")) {
      Object obj = map.get("reopen_invoice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReopenInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_code")) {
      Object obj = map.get("customer_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pos_date")) {
      Object obj = map.get("pos_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPosDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPosDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPosDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPosDate(null);
      }
    }
    if(map.containsKey("invoice_flag")) {
      Object obj = map.get("invoice_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("email")) {
      Object obj = map.get("email");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEmail((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("orderAndStoreRelationship.id")) {
        Object obj = map.get("orderAndStoreRelationship.id");
      if(obj instanceof Long) {
        entity.setOrderAndStoreRelationshipId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setOrderAndStoreRelationshipId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("store_code")) {
      Object obj = map.get("store_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pos_no")) {
      Object obj = map.get("pos_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPosNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outer_discount_with_tax")) {
      Object obj = map.get("outer_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("mi_account")) {
      Object obj = map.get("mi_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMiAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cashier_name")) {
      Object obj = map.get("cashier_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCashierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoicer_name")) {
      Object obj = map.get("invoicer_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_bill_type")) {
      Object obj = map.get("business_bill_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessBillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_id")) {
      Object obj = map.get("customer_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cust_name")) {
      Object obj = map.get("cust_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cust_company_type")) {
      Object obj = map.get("cust_company_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustCompanyType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cust_address_building_name")) {
      Object obj = map.get("cust_address_building_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustAddressBuildingName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cust_phone_number")) {
      Object obj = map.get("cust_phone_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustPhoneNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cust_address_city_name")) {
      Object obj = map.get("cust_address_city_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustAddressCityName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cust_address_street_name")) {
      Object obj = map.get("cust_address_street_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustAddressStreetName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cust_number")) {
      Object obj = map.get("cust_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("kcpo_fiscal_id")) {
      Object obj = map.get("kcpo_fiscal_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKcpoFiscalId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("kcpo_purposed_escription")) {
      Object obj = map.get("kcpo_purposed_escription");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKcpoPurposedEscription((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_code")) {
      Object obj = map.get("tax_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cust_invoice_type_code")) {
      Object obj = map.get("cust_invoice_type_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustInvoiceTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cod_code")) {
      Object obj = map.get("cod_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCodCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("comment")) {
      Object obj = map.get("comment");
      if(obj != null) {
        if(obj instanceof String) {
          this.setComment((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("card_holder_last_name")) {
      Object obj = map.get("card_holder_last_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCardHolderLastName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("card_holder_first_name")) {
      Object obj = map.get("card_holder_first_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCardHolderFirstName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_operation_version")) {
      Object obj = map.get("invoice_operation_version");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceOperationVersion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("legal_invoice_flag")) {
      Object obj = map.get("legal_invoice_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLegalInvoiceFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_info_no")) {
      Object obj = map.get("order_info_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderInfoNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("group_flag")) {
      Object obj = map.get("group_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGroupFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_info_fill")) {
      Object obj = map.get("seller_info_fill");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerInfoFill((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_info_fill")) {
      Object obj = map.get("purchaser_info_fill");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserInfoFill((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("return_flg")) {
      Object obj = map.get("return_flg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnFlg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("read_flg")) {
      Object obj = map.get("read_flg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReadFlg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_total_amount")) {
      Object obj = map.get("invoice_total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoice_total_tax")) {
      Object obj = map.get("invoice_total_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceTotalTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceTotalTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceTotalTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceTotalTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceTotalTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("pos_time")) {
      Object obj = map.get("pos_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPosTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_total_top_pay_amount")) {
      Object obj = map.get("invoice_total_top_pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceTotalTopPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceTotalTopPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceTotalTopPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceTotalTopPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceTotalTopPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoice_total_col_li")) {
      Object obj = map.get("invoice_total_col_li");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceTotalColLi((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceTotalColLi(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceTotalColLi(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceTotalColLi(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceTotalColLi(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("mail_address")) {
      Object obj = map.get("mail_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMailAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_with_taxes_total_amount")) {
      Object obj = map.get("order_with_taxes_total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrderWithTaxesTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrderWithTaxesTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrderWithTaxesTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderWithTaxesTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderWithTaxesTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("order_with_taxes_total_discount_amount")) {
      Object obj = map.get("order_with_taxes_total_discount_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrderWithTaxesTotalDiscountAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrderWithTaxesTotalDiscountAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrderWithTaxesTotalDiscountAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderWithTaxesTotalDiscountAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderWithTaxesTotalDiscountAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("search_id")) {
      Object obj = map.get("search_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSearchId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_total_count")) {
      Object obj = map.get("order_total_count");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderTotalCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderTotalCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderTotalCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("order_total_qty_count")) {
      Object obj = map.get("order_total_qty_count");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrderTotalQtyCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrderTotalQtyCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrderTotalQtyCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderTotalQtyCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderTotalQtyCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("order_total_amount")) {
      Object obj = map.get("order_total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrderTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrderTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrderTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("order_total_tax")) {
      Object obj = map.get("order_total_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrderTotalTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrderTotalTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrderTotalTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderTotalTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderTotalTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("joinchar")) {
      Object obj = map.get("joinchar");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJoinchar((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("boutique_code")) {
      Object obj = map.get("boutique_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBoutiqueCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("boutique_country")) {
      Object obj = map.get("boutique_country");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBoutiqueCountry((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_addr")) {
      Object obj = map.get("purchaser_addr");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_bank_info")) {
      Object obj = map.get("purchaser_bank_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("actual_invoice_amount_with_tax")) {
      Object obj = map.get("actual_invoice_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setActualInvoiceAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setActualInvoiceAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setActualInvoiceAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActualInvoiceAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setActualInvoiceAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("actual_invoice_outer_discount_with_tax")) {
      Object obj = map.get("actual_invoice_outer_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setActualInvoiceOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setActualInvoiceOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setActualInvoiceOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActualInvoiceOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setActualInvoiceOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("richemont_order_extend_flag")) {
      Object obj = map.get("richemont_order_extend_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRichemontOrderExtendFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("qrcode_expire_day")) {
      Object obj = map.get("qrcode_expire_day");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setQrcodeExpireDay((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setQrcodeExpireDay(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setQrcodeExpireDay(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("store_name")) {
      Object obj = map.get("store_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlement_amount_with_tax")) {
      Object obj = map.get("settlement_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSettlementAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSettlementAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSettlementAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSettlementAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("return_pos_no")) {
      Object obj = map.get("return_pos_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnPosNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reopen_invoice")) {
      Object obj = map.get("reopen_invoice");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReopenInvoice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_code")) {
      Object obj = map.get("customer_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pos_date")) {
      Object obj = map.get("pos_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPosDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPosDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPosDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPosDate(null);
      }
    }
    if(map.containsKey("invoice_flag")) {
      Object obj = map.get("invoice_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("email")) {
      Object obj = map.get("email");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEmail((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("orderAndStoreRelationship.id")) {
        Object obj = map.get("orderAndStoreRelationship.id");
        if(obj instanceof Long) {
          this.setOrderAndStoreRelationshipId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderAndStoreRelationshipId(Long.parseLong((String)obj));
        }
      }
  }
}
