package com.xforceplus.ultraman.app.jcrichemont.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 结算单明细表
 * </p>
 *
 * @author ultraman
 * @since 2024-05-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SettlementDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务单号
   */
  private String settlementNo;

  /**
   * 订单编号
   */
  private String orderNo;

  /**
   * 订单明细行号
   */
  private String orderItemNo;

  /**
   * 结算单唯一号
   */
  private String posNo;

  /**
   * 商品税编
   */
  private String itemCode;

  /**
   * 商品描述
   */
  private String itemName;

  /**
   * 商品规格
   */
  private String itemSpec;

  /**
   * 单位
   */
  private String quantityUnit;

  /**
   * 可开数量
   */
  private BigDecimal quantity;

  /**
   * 单价
   */
  private BigDecimal unitPrice;

  /**
   * 可开不含税金额
   */
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  private BigDecimal taxAmount;

  /**
   * 已分摊折扣
   */
  private BigDecimal outerDiscountWithTax;

  /**
   * 商品编码
   */
  private String volunCode;

  /**
   * 可开含税金额
   */
  private BigDecimal amountWithTax;

  /**
   * 税率
   */
  private BigDecimal taxRate;

  /**
   * 是否享受税收优惠政策
   */
  private String taxPre;

  /**
   * 享受税收优惠政策内容
   */
  private String taxPreCon;

  /**
   * 零税率标记
   */
  private String zeroTax;

  /**
   * 法律发票标记
   */
  private String legalInvoiceFlag;

  /**
   * 已开发票金额
   */
  private BigDecimal invoicedAmount;

  /**
   * 已开发票数量
   */
  private BigDecimal invoicedQuantity;

  /**
   * 发票状态
   */
  private String invoiceStatus;

  /**
   * 退货数量
   */
  private BigDecimal returnQuantity;

  /**
   * 退货金额
   */
  private BigDecimal returnAmount;

  /**
   * 退货标记
   */
  private String returnFlag;

  /**
   * 发票标记
   */
  private String invoiceFlag;

  /**
   * 支付金额
   */
  private BigDecimal payAmount;

  /**
   * 业务单明细行
   */
  private String settlementDetailcol;

  /**
   * 原始含税金额
   */
  private BigDecimal originalAmountWithTax;

  /**
   * 原始不含税金额
   */
  private BigDecimal originalOuterDiscountWithTax;

  /**
   * 发票代码
   */
  private String invoiceCode;

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * 原始发票代码
   */
  private String originInvoiceCode;

  /**
   * 原始发票号码
   */
  private String originInvoiceNo;

  /**
   * 特殊发票支付金额
   */
  private BigDecimal specialInvoicePayAmount;

  /**
   * 退货和开票标记
   */
  private String returnFlagAndInvoiceFlag;

  /**
   * 赠品标志
   */
  private String isGiftFlag;

  /**
   * 是否有赠品
   */
  private String hasGiftFlag;

  /**
   * 赠品对应的正品明细号
   */
  private String giftToGoodsNo;

  /**
   * 退货单号
   */
  private String returnPosNo;

  /**
   * 发票代码组
   */
  private String invoiceCodeGroup;

  /**
   * 发票号码组
   */
  private String invoiceNoGroup;

  /**
   * 结算单组
   */
  private String posNoGroup;

  /**
   * 购方信息填写
   */
  private String purchaserInfoFill;

  /**
   * 购方税号
   */
  private String purchaserTaxNo;

  /**
   * 购方名称
   */
  private String purchaserName;

  /**
   * 购方地址电话
   */
  private String purchaserAddrTel;

  /**
   * 购方地址
   */
  private String purchaserAddress;

  /**
   * 购方电话
   */
  private String purchaserTel;

  /**
   * 购方银行信息
   */
  private String purchaserBankInfo;

  /**
   * 购方名称
   */
  private String purchaserBankName;

  /**
   * 购方账号
   */
  private String purchaserBankAccount;

  /**
   * 历峰上传的数量
   */
  private BigDecimal remarkQuantity;

  /**
   * 历峰上传的含税金额
   */
  private BigDecimal remarkAmountWithTax;

  /**
   * 备用
   */
  private String remarkR;

  /**
   * 备用1
   */
  private String remarkR1;

  /**
   * 备用2
   */
  private String remarkR2;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("settlement_no", settlementNo);
      map.put("order_no", orderNo);
      map.put("order_item_no", orderItemNo);
      map.put("pos_no", posNo);
      map.put("item_code", itemCode);
      map.put("item_name", itemName);
      map.put("item_spec", itemSpec);
      map.put("quantity_unit", quantityUnit);
      map.put("quantity", quantity);
      map.put("unit_price", unitPrice);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("tax_amount", taxAmount);
      map.put("outer_discount_with_tax", outerDiscountWithTax);
      map.put("volun_code", volunCode);
      map.put("amount_with_tax", amountWithTax);
      map.put("tax_rate", taxRate);
      map.put("tax_pre", taxPre);
      map.put("tax_pre_con", taxPreCon);
      map.put("zero_tax", zeroTax);
      map.put("legal_invoice_flag", legalInvoiceFlag);
      map.put("invoiced_amount", invoicedAmount);
      map.put("invoiced_quantity", invoicedQuantity);
      map.put("invoice_status", invoiceStatus);
      map.put("return_quantity", returnQuantity);
      map.put("return_amount", returnAmount);
      map.put("return_flag", returnFlag);
      map.put("invoice_flag", invoiceFlag);
      map.put("pay_amount", payAmount);
      map.put("settlement_detailcol", settlementDetailcol);
      map.put("original_amount_with_tax", originalAmountWithTax);
      map.put("original_outer_discount_with_tax", originalOuterDiscountWithTax);
      map.put("invoice_code", invoiceCode);
      map.put("invoice_no", invoiceNo);
      map.put("origin_invoice_code", originInvoiceCode);
      map.put("origin_invoice_no", originInvoiceNo);
      map.put("special_invoice_pay_amount", specialInvoicePayAmount);
      map.put("return_flag_and_invoice_flag", returnFlagAndInvoiceFlag);
      map.put("is_gift_flag", isGiftFlag);
      map.put("has_gift_flag", hasGiftFlag);
      map.put("gift_to_goods_no", giftToGoodsNo);
      map.put("return_pos_no", returnPosNo);
      map.put("invoice_code_group", invoiceCodeGroup);
      map.put("invoice_no_group", invoiceNoGroup);
      map.put("pos_no_group", posNoGroup);
      map.put("purchaser_info_fill", purchaserInfoFill);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("purchaser_name", purchaserName);
      map.put("purchaser_addr_tel", purchaserAddrTel);
      map.put("purchaser_address", purchaserAddress);
      map.put("purchaser_tel", purchaserTel);
      map.put("purchaser_bank_info", purchaserBankInfo);
      map.put("purchaser_bank_name", purchaserBankName);
      map.put("purchaser_bank_account", purchaserBankAccount);
      map.put("remark_quantity", remarkQuantity);
      map.put("remark_amount_with_tax", remarkAmountWithTax);
      map.put("remark_r", remarkR);
      map.put("remark_r1", remarkR1);
      map.put("remark_r2", remarkR2);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static SettlementDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SettlementDetail entity = new SettlementDetail();
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_item_no")) {
      Object obj = map.get("order_item_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pos_no")) {
      Object obj = map.get("pos_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPosNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_code")) {
      Object obj = map.get("item_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_spec")) {
      Object obj = map.get("item_spec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity_unit")) {
      Object obj = map.get("quantity_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit_price")) {
      Object obj = map.get("unit_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outer_discount_with_tax")) {
      Object obj = map.get("outer_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("volun_code")) {
      Object obj = map.get("volun_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVolunCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_pre")) {
      Object obj = map.get("tax_pre");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPre((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_pre_con")) {
      Object obj = map.get("tax_pre_con");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPreCon((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zero_tax")) {
      Object obj = map.get("zero_tax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZeroTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("legal_invoice_flag")) {
      Object obj = map.get("legal_invoice_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLegalInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiced_amount")) {
      Object obj = map.get("invoiced_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoicedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoicedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoicedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoicedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoicedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiced_quantity")) {
      Object obj = map.get("invoiced_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoicedQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoicedQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoicedQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoicedQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoicedQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_quantity")) {
      Object obj = map.get("return_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReturnQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReturnQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReturnQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReturnQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReturnQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("return_amount")) {
      Object obj = map.get("return_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReturnAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReturnAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReturnAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReturnAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReturnAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("return_flag")) {
      Object obj = map.get("return_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_flag")) {
      Object obj = map.get("invoice_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlement_detailcol")) {
      Object obj = map.get("settlement_detailcol");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementDetailcol((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("original_amount_with_tax")) {
      Object obj = map.get("original_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOriginalAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOriginalAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOriginalAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOriginalAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOriginalAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("original_outer_discount_with_tax")) {
      Object obj = map.get("original_outer_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOriginalOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOriginalOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOriginalOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOriginalOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOriginalOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("special_invoice_pay_amount")) {
      Object obj = map.get("special_invoice_pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSpecialInvoicePayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSpecialInvoicePayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSpecialInvoicePayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSpecialInvoicePayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSpecialInvoicePayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("return_flag_and_invoice_flag")) {
      Object obj = map.get("return_flag_and_invoice_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnFlagAndInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_gift_flag")) {
      Object obj = map.get("is_gift_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsGiftFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("has_gift_flag")) {
      Object obj = map.get("has_gift_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHasGiftFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gift_to_goods_no")) {
      Object obj = map.get("gift_to_goods_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGiftToGoodsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_pos_no")) {
      Object obj = map.get("return_pos_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnPosNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code_group")) {
      Object obj = map.get("invoice_code_group");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCodeGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no_group")) {
      Object obj = map.get("invoice_no_group");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNoGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pos_no_group")) {
      Object obj = map.get("pos_no_group");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPosNoGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_info_fill")) {
      Object obj = map.get("purchaser_info_fill");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserInfoFill((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_addr_tel")) {
      Object obj = map.get("purchaser_addr_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_info")) {
      Object obj = map.get("purchaser_bank_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_name")) {
      Object obj = map.get("purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark_quantity")) {
      Object obj = map.get("remark_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRemarkQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRemarkQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRemarkQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRemarkQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRemarkQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark_amount_with_tax")) {
      Object obj = map.get("remark_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRemarkAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRemarkAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRemarkAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRemarkAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRemarkAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark_r")) {
      Object obj = map.get("remark_r");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemarkR((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark_r1")) {
      Object obj = map.get("remark_r1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemarkR1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark_r2")) {
      Object obj = map.get("remark_r2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemarkR2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_item_no")) {
      Object obj = map.get("order_item_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderItemNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pos_no")) {
      Object obj = map.get("pos_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPosNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_code")) {
      Object obj = map.get("item_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_spec")) {
      Object obj = map.get("item_spec");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemSpec((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity_unit")) {
      Object obj = map.get("quantity_unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQuantityUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unit_price")) {
      Object obj = map.get("unit_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outer_discount_with_tax")) {
      Object obj = map.get("outer_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("volun_code")) {
      Object obj = map.get("volun_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVolunCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_pre")) {
      Object obj = map.get("tax_pre");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPre((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_pre_con")) {
      Object obj = map.get("tax_pre_con");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPreCon((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zero_tax")) {
      Object obj = map.get("zero_tax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZeroTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("legal_invoice_flag")) {
      Object obj = map.get("legal_invoice_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLegalInvoiceFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiced_amount")) {
      Object obj = map.get("invoiced_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoicedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoicedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoicedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoicedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoicedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiced_quantity")) {
      Object obj = map.get("invoiced_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoicedQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoicedQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoicedQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoicedQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoicedQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("return_quantity")) {
      Object obj = map.get("return_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReturnQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReturnQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReturnQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReturnQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReturnQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("return_amount")) {
      Object obj = map.get("return_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReturnAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReturnAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReturnAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReturnAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReturnAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("return_flag")) {
      Object obj = map.get("return_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_flag")) {
      Object obj = map.get("invoice_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("settlement_detailcol")) {
      Object obj = map.get("settlement_detailcol");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementDetailcol((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("original_amount_with_tax")) {
      Object obj = map.get("original_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOriginalAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOriginalAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOriginalAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOriginalAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOriginalAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("original_outer_discount_with_tax")) {
      Object obj = map.get("original_outer_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOriginalOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOriginalOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOriginalOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOriginalOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOriginalOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("special_invoice_pay_amount")) {
      Object obj = map.get("special_invoice_pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSpecialInvoicePayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSpecialInvoicePayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSpecialInvoicePayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSpecialInvoicePayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSpecialInvoicePayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("return_flag_and_invoice_flag")) {
      Object obj = map.get("return_flag_and_invoice_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnFlagAndInvoiceFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_gift_flag")) {
      Object obj = map.get("is_gift_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsGiftFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("has_gift_flag")) {
      Object obj = map.get("has_gift_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHasGiftFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gift_to_goods_no")) {
      Object obj = map.get("gift_to_goods_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGiftToGoodsNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("return_pos_no")) {
      Object obj = map.get("return_pos_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnPosNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_code_group")) {
      Object obj = map.get("invoice_code_group");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCodeGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_no_group")) {
      Object obj = map.get("invoice_no_group");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNoGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pos_no_group")) {
      Object obj = map.get("pos_no_group");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPosNoGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_info_fill")) {
      Object obj = map.get("purchaser_info_fill");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserInfoFill((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_addr_tel")) {
      Object obj = map.get("purchaser_addr_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_bank_info")) {
      Object obj = map.get("purchaser_bank_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_bank_name")) {
      Object obj = map.get("purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark_quantity")) {
      Object obj = map.get("remark_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRemarkQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRemarkQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRemarkQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRemarkQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRemarkQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remark_amount_with_tax")) {
      Object obj = map.get("remark_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRemarkAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRemarkAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRemarkAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRemarkAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRemarkAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remark_r")) {
      Object obj = map.get("remark_r");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemarkR((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark_r1")) {
      Object obj = map.get("remark_r1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemarkR1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark_r2")) {
      Object obj = map.get("remark_r2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemarkR2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
