package com.xforceplus.ultraman.app.jcrichemont.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 结算单主表
 * </p>
 *
 * @author ultraman
 * @since 2024-05-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SettlementMain implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务单号
   */
  private String settlementNo;

  /**
   * 结算单唯一号
   */
  private String posNo;

  /**
   * 销方信息填写
   */
  private String sellerInfoFill;

  /**
   * 门店号
   */
  private String storeCode;

  /**
   * 销方税号
   */
  private String sellerTaxNo;

  /**
   * 销方名称
   */
  private String sellerName;

  /**
   * 销方地址电话
   */
  private String sellerAddrTel;

  /**
   * 销方地址
   */
  private String sellerAddress;

  /**
   * 销方电话
   */
  private String sellerTel;

  /**
   * 销方银行信息
   */
  private String sellerBankInfo;

  /**
   * 销方银行名称
   */
  private String sellerBankName;

  /**
   * 销方银行账号
   */
  private String sellerBankAccount;

  /**
   * 购方信息填写
   */
  private String purchaserInfoFill;

  /**
   * 购方税号
   */
  private String purchaserTaxNo;

  /**
   * 购方名称
   */
  private String purchaserName;

  /**
   * 购方地址电话
   */
  private String purchaserAddrTel;

  /**
   * 购方地址
   */
  private String purchaserAddress;

  /**
   * 购方电话
   */
  private String purchaserTel;

  /**
   * 购方银行信息
   */
  private String purchaserBankInfo;

  /**
   * 购方银行名称
   */
  private String purchaserBankName;

  /**
   * 购方银行账号
   */
  private String purchaserBankAccount;

  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;

  /**
   * 折扣
   */
  private BigDecimal outerDiscountWithTax;

  /**
   * 发票类型
   */
  private String invoiceType;

  /**
   * mi账号
   */
  private String miAccount;

  /**
   * 订单日期
   */
  private String posDate;

  /**
   * 备注
   */
  private String remark;

  /**
   * 检验人
   */
  private String cashierName;

  /**
   * 审核人
   */
  private String checkerName;

  /**
   * 开票人
   */
  private String invoicerName;

  /**
   * 邮件
   */
  private String email;

  /**
   * 业务单类型
   */
  private String businessBillType;

  /**
   * 状态
   */
  private String status;

  /**
   * 订单类型
   */
  private String orderType;

  /**
   * 实际支付金额
   */
  private BigDecimal payAmount;

  /**
   * 订单号
   */
  private String orderInfoNo;

  /**
   * 注释
   */
  private String comment;

  /**
   * 发票状态
   */
  private String invoiceStatus;

  /**
   * 退货次数
   */
  private String lastReturnTime;

  /**
   * 退货单标记
   */
  @TableField("returnFlg")
  private String returnFlg;

  /**
   * 门店名称
   */
  private String storeName;

  /**
   * 原始发票编号
   */
  private String originInvoiceCode;

  /**
   * 原始发票号码
   */
  private String originInvoiceNo;

  /**
   * 订单号
   */
  private String orderId;

  /**
   * 发票标记
   */
  private String invoiceFlag;

  /**
   * 品牌
   */
  private String brand;

  /**
   * 发票代码
   */
  private String invoiceCode;

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * 系统扩展字段
   */
  private String reopenInvoice;

  /**
   * 退货结算单号
   */
  private String returnPosNo;

  /**
   * 发票代码组
   */
  private String invoiceCodeGroup;

  /**
   * 发票号码组
   */
  private String invoiceNoGroup;

  /**
   * 结算单号组
   */
  private String posNoGroup;

  /**
   * 新的购方税号
   */
  private String newPurchaserTaxNo;

  /**
   * 新的购方名称
   */
  private String newPurchaserName;

  /**
   * 新的购方邮箱地址
   */
  private String newEmail;

  /**
   * 客户代码
   */
  private String customerCode;

  /**
   * 新的购方银行账号
   */
  private String newPurchaserBankAccount;

  /**
   * 新的购方银行信息
   */
  private String newPurchaserBankInfo;

  /**
   * 新的购方电话
   */
  private String newPurchaserTel;

  /**
   * 新的购方地址
   */
  private String newPurchaserAddress;

  /**
   * 新的购方银行名称
   */
  private String newPurchaserBankName;

  /**
   * 新的购方地址电话
   */
  private String newPurchaserAddrTel;

  /**
   * 新的购方地址
   */
  private String purchaserAddr;

  /**
   * 历峰组合订单号
   */
  private String posNoTemp;

  /**
   * 结算单反馈
   */
  private String messages;

  /**
   * 订单金额
   */
  private BigDecimal orderAmountWithTax;

  /**
   * 备注1
   */
  private String remark1;

  /**
   * 备注2
   */
  private String remark2;

  /**
   * 备注3
   */
  private String remark3;

  /**
   * 备注4
   */
  private String remark4;

  /**
   * 发票备注栏显示的订单号
   */
  private String displayOrderNo;

  /**
   * 渠道
   */
  private String channel;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("settlement_no", settlementNo);
      map.put("pos_no", posNo);
      map.put("seller_info_fill", sellerInfoFill);
      map.put("store_code", storeCode);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("seller_name", sellerName);
      map.put("seller_addr_tel", sellerAddrTel);
      map.put("seller_address", sellerAddress);
      map.put("seller_tel", sellerTel);
      map.put("seller_bank_info", sellerBankInfo);
      map.put("seller_bank_name", sellerBankName);
      map.put("seller_bank_account", sellerBankAccount);
      map.put("purchaser_info_fill", purchaserInfoFill);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("purchaser_name", purchaserName);
      map.put("purchaser_addr_tel", purchaserAddrTel);
      map.put("purchaser_address", purchaserAddress);
      map.put("purchaser_tel", purchaserTel);
      map.put("purchaser_bank_info", purchaserBankInfo);
      map.put("purchaser_bank_name", purchaserBankName);
      map.put("purchaser_bank_account", purchaserBankAccount);
      map.put("amount_with_tax", amountWithTax);
      map.put("outer_discount_with_tax", outerDiscountWithTax);
      map.put("invoice_type", invoiceType);
      map.put("mi_account", miAccount);
      map.put("pos_date", posDate);
      map.put("remark", remark);
      map.put("cashier_name", cashierName);
      map.put("checker_name", checkerName);
      map.put("invoicer_name", invoicerName);
      map.put("email", email);
      map.put("business_bill_type", businessBillType);
      map.put("status", status);
      map.put("order_type", orderType);
      map.put("pay_amount", payAmount);
      map.put("order_info_no", orderInfoNo);
      map.put("comment", comment);
      map.put("invoice_status", invoiceStatus);
      map.put("last_return_time", lastReturnTime);
      map.put("returnFlg", returnFlg);
      map.put("store_name", storeName);
      map.put("origin_invoice_code", originInvoiceCode);
      map.put("origin_invoice_no", originInvoiceNo);
      map.put("order_id", orderId);
      map.put("invoice_flag", invoiceFlag);
      map.put("brand", brand);
      map.put("invoice_code", invoiceCode);
      map.put("invoice_no", invoiceNo);
      map.put("reopen_invoice", reopenInvoice);
      map.put("return_pos_no", returnPosNo);
      map.put("invoice_code_group", invoiceCodeGroup);
      map.put("invoice_no_group", invoiceNoGroup);
      map.put("pos_no_group", posNoGroup);
      map.put("new_purchaser_tax_no", newPurchaserTaxNo);
      map.put("new_purchaser_name", newPurchaserName);
      map.put("new_email", newEmail);
      map.put("customer_code", customerCode);
      map.put("new_purchaser_bank_account", newPurchaserBankAccount);
      map.put("new_purchaser_bank_info", newPurchaserBankInfo);
      map.put("new_purchaser_tel", newPurchaserTel);
      map.put("new_purchaser_address", newPurchaserAddress);
      map.put("new_purchaser_bank_name", newPurchaserBankName);
      map.put("new_purchaser_addr_tel", newPurchaserAddrTel);
      map.put("purchaser_addr", purchaserAddr);
      map.put("pos_no_temp", posNoTemp);
      map.put("messages", messages);
      map.put("order_amount_with_tax", orderAmountWithTax);
      map.put("remark1", remark1);
      map.put("remark2", remark2);
      map.put("remark3", remark3);
      map.put("remark4", remark4);
      map.put("display_order_no", displayOrderNo);
      map.put("channel", channel);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static SettlementMain fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SettlementMain entity = new SettlementMain();
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pos_no")) {
      Object obj = map.get("pos_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPosNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_info_fill")) {
      Object obj = map.get("seller_info_fill");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerInfoFill((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_code")) {
      Object obj = map.get("store_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_addr_tel")) {
      Object obj = map.get("seller_addr_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tel")) {
      Object obj = map.get("seller_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_info")) {
      Object obj = map.get("seller_bank_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_name")) {
      Object obj = map.get("seller_bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_account")) {
      Object obj = map.get("seller_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_info_fill")) {
      Object obj = map.get("purchaser_info_fill");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserInfoFill((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_addr_tel")) {
      Object obj = map.get("purchaser_addr_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_info")) {
      Object obj = map.get("purchaser_bank_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_name")) {
      Object obj = map.get("purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outer_discount_with_tax")) {
      Object obj = map.get("outer_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mi_account")) {
      Object obj = map.get("mi_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMiAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pos_date")) {
      Object obj = map.get("pos_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPosDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashier_name")) {
      Object obj = map.get("cashier_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicer_name")) {
      Object obj = map.get("invoicer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("email")) {
      Object obj = map.get("email");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_bill_type")) {
      Object obj = map.get("business_bill_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("order_info_no")) {
      Object obj = map.get("order_info_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderInfoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("comment")) {
      Object obj = map.get("comment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setComment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("last_return_time")) {
      Object obj = map.get("last_return_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLastReturnTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returnFlg")) {
      Object obj = map.get("returnFlg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnFlg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_name")) {
      Object obj = map.get("store_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_flag")) {
      Object obj = map.get("invoice_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reopen_invoice")) {
      Object obj = map.get("reopen_invoice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReopenInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_pos_no")) {
      Object obj = map.get("return_pos_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnPosNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code_group")) {
      Object obj = map.get("invoice_code_group");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCodeGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no_group")) {
      Object obj = map.get("invoice_no_group");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNoGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pos_no_group")) {
      Object obj = map.get("pos_no_group");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPosNoGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_purchaser_tax_no")) {
      Object obj = map.get("new_purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_purchaser_name")) {
      Object obj = map.get("new_purchaser_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_email")) {
      Object obj = map.get("new_email");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_code")) {
      Object obj = map.get("customer_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_purchaser_bank_account")) {
      Object obj = map.get("new_purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_purchaser_bank_info")) {
      Object obj = map.get("new_purchaser_bank_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewPurchaserBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_purchaser_tel")) {
      Object obj = map.get("new_purchaser_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_purchaser_address")) {
      Object obj = map.get("new_purchaser_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_purchaser_bank_name")) {
      Object obj = map.get("new_purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_purchaser_addr_tel")) {
      Object obj = map.get("new_purchaser_addr_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_addr")) {
      Object obj = map.get("purchaser_addr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pos_no_temp")) {
      Object obj = map.get("pos_no_temp");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPosNoTemp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("messages")) {
      Object obj = map.get("messages");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMessages((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_amount_with_tax")) {
      Object obj = map.get("order_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark1")) {
      Object obj = map.get("remark1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark2")) {
      Object obj = map.get("remark2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark3")) {
      Object obj = map.get("remark3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark4")) {
      Object obj = map.get("remark4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("display_order_no")) {
      Object obj = map.get("display_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDisplayOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pos_no")) {
      Object obj = map.get("pos_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPosNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_info_fill")) {
      Object obj = map.get("seller_info_fill");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerInfoFill((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("store_code")) {
      Object obj = map.get("store_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_addr_tel")) {
      Object obj = map.get("seller_addr_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tel")) {
      Object obj = map.get("seller_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_bank_info")) {
      Object obj = map.get("seller_bank_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_bank_name")) {
      Object obj = map.get("seller_bank_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_bank_account")) {
      Object obj = map.get("seller_bank_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_info_fill")) {
      Object obj = map.get("purchaser_info_fill");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserInfoFill((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_addr_tel")) {
      Object obj = map.get("purchaser_addr_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_bank_info")) {
      Object obj = map.get("purchaser_bank_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_bank_name")) {
      Object obj = map.get("purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outer_discount_with_tax")) {
      Object obj = map.get("outer_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mi_account")) {
      Object obj = map.get("mi_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMiAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pos_date")) {
      Object obj = map.get("pos_date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPosDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cashier_name")) {
      Object obj = map.get("cashier_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCashierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoicer_name")) {
      Object obj = map.get("invoicer_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("email")) {
      Object obj = map.get("email");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_bill_type")) {
      Object obj = map.get("business_bill_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessBillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("order_info_no")) {
      Object obj = map.get("order_info_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderInfoNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("comment")) {
      Object obj = map.get("comment");
      if(obj != null) {
        if(obj instanceof String) {
          this.setComment((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("last_return_time")) {
      Object obj = map.get("last_return_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLastReturnTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("returnFlg")) {
      Object obj = map.get("returnFlg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnFlg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("store_name")) {
      Object obj = map.get("store_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_flag")) {
      Object obj = map.get("invoice_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reopen_invoice")) {
      Object obj = map.get("reopen_invoice");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReopenInvoice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("return_pos_no")) {
      Object obj = map.get("return_pos_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnPosNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_code_group")) {
      Object obj = map.get("invoice_code_group");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCodeGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_no_group")) {
      Object obj = map.get("invoice_no_group");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNoGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pos_no_group")) {
      Object obj = map.get("pos_no_group");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPosNoGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("new_purchaser_tax_no")) {
      Object obj = map.get("new_purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNewPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("new_purchaser_name")) {
      Object obj = map.get("new_purchaser_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNewPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("new_email")) {
      Object obj = map.get("new_email");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNewEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_code")) {
      Object obj = map.get("customer_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("new_purchaser_bank_account")) {
      Object obj = map.get("new_purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNewPurchaserBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("new_purchaser_bank_info")) {
      Object obj = map.get("new_purchaser_bank_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNewPurchaserBankInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("new_purchaser_tel")) {
      Object obj = map.get("new_purchaser_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNewPurchaserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("new_purchaser_address")) {
      Object obj = map.get("new_purchaser_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNewPurchaserAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("new_purchaser_bank_name")) {
      Object obj = map.get("new_purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNewPurchaserBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("new_purchaser_addr_tel")) {
      Object obj = map.get("new_purchaser_addr_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNewPurchaserAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_addr")) {
      Object obj = map.get("purchaser_addr");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pos_no_temp")) {
      Object obj = map.get("pos_no_temp");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPosNoTemp((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("messages")) {
      Object obj = map.get("messages");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMessages((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_amount_with_tax")) {
      Object obj = map.get("order_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrderAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrderAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrderAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remark1")) {
      Object obj = map.get("remark1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark2")) {
      Object obj = map.get("remark2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark3")) {
      Object obj = map.get("remark3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark4")) {
      Object obj = map.get("remark4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("display_order_no")) {
      Object obj = map.get("display_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDisplayOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
