package com.xforceplus.ultraman.app.jcrichemont.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcrichemont.entity.ChangePosNo;
import com.xforceplus.ultraman.app.jcrichemont.service.IChangePosNoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 组合结算单号表前端控制器
 *
 * @author ultraman
 * @date 2024-03-18
 */
@RestController
public class ChangePosNoController {

  @Autowired
  private IChangePosNoService changePosNoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param changePosNo 组合结算单号表
   * @return
   */
  @GetMapping("/changeposnos" )
  public XfR getChangePosNos(XfPage page, ChangePosNo changePosNo) {
    return XfR.ok(changePosNoServiceImpl.page(page, Wrappers.query(changePosNo)));
  }

  /**
   * 通过id查询组合结算单号表
   * @param  id
   * @return XfR
   */
  @GetMapping("/changeposnos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(changePosNoServiceImpl.getById(id));
  }

  /**
   * 新增组合结算单号表
   * @param changePosNo 组合结算单号表
   * @return XfR
   */
  @PostMapping("/changeposnos")
  public XfR save(@RequestBody ChangePosNo changePosNo) {
     return XfR.ok(changePosNoServiceImpl.save(changePosNo));
  }

  /**
   * 修改-传入修改后的全部数据组合结算单号表
   * @param changePosNo 组合结算单号表
   * @return XfR
   */
  @PutMapping("/changeposnos/{id}")
  public XfR putUpdate(@RequestBody ChangePosNo changePosNo,@PathVariable Long id) {
      changePosNo.setId(id);
      return XfR.ok(changePosNoServiceImpl.updateById(changePosNo));
  }

  /**
   * 修改-传入修改的数据组合结算单号表
   * @param changePosNo 组合结算单号表
   * @return XfR
   */
  @PatchMapping("/changeposnos/{id}")
  public XfR patchUpdate(@RequestBody ChangePosNo changePosNo,@PathVariable Long id) {
      ChangePosNo upchangePosNo = changePosNoServiceImpl.getById(id);
      if(upchangePosNo != null){
        upchangePosNo = ObjectCopyUtils.copyProperties(changePosNo,upchangePosNo,true);
      }
      return XfR.ok(changePosNoServiceImpl.updateById(upchangePosNo));
  }

  /**
   * 通过id删除组合结算单号表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/changeposnos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(changePosNoServiceImpl.removeById(id));
  }

  @PostMapping("/changeposnos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "change_pos_no");
     params.put("request", condition);

     return XfR.ok(changePosNoServiceImpl.querys(params));
  }

}
