package com.xforceplus.ultraman.app.jcrichemont.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcrichemont.entity.OrderInfoDetail;
import com.xforceplus.ultraman.app.jcrichemont.service.IOrderInfoDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 订单明细表前端控制器
 *
 * @author ultraman
 * @date 2024-03-18
 */
@RestController
public class OrderInfoDetailController {

  @Autowired
  private IOrderInfoDetailService orderInfoDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderInfoDetail 订单明细表
   * @return
   */
  @GetMapping("/orderinfodetails" )
  public XfR getOrderInfoDetails(XfPage page, OrderInfoDetail orderInfoDetail) {
    return XfR.ok(orderInfoDetailServiceImpl.page(page, Wrappers.query(orderInfoDetail)));
  }

  /**
   * 通过id查询订单明细表
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderinfodetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderInfoDetailServiceImpl.getById(id));
  }

  /**
   * 新增订单明细表
   * @param orderInfoDetail 订单明细表
   * @return XfR
   */
  @PostMapping("/orderinfodetails")
  public XfR save(@RequestBody OrderInfoDetail orderInfoDetail) {
     return XfR.ok(orderInfoDetailServiceImpl.save(orderInfoDetail));
  }

  /**
   * 修改-传入修改后的全部数据订单明细表
   * @param orderInfoDetail 订单明细表
   * @return XfR
   */
  @PutMapping("/orderinfodetails/{id}")
  public XfR putUpdate(@RequestBody OrderInfoDetail orderInfoDetail,@PathVariable Long id) {
      orderInfoDetail.setId(id);
      return XfR.ok(orderInfoDetailServiceImpl.updateById(orderInfoDetail));
  }

  /**
   * 修改-传入修改的数据订单明细表
   * @param orderInfoDetail 订单明细表
   * @return XfR
   */
  @PatchMapping("/orderinfodetails/{id}")
  public XfR patchUpdate(@RequestBody OrderInfoDetail orderInfoDetail,@PathVariable Long id) {
      OrderInfoDetail uporderInfoDetail = orderInfoDetailServiceImpl.getById(id);
      if(uporderInfoDetail != null){
        uporderInfoDetail = ObjectCopyUtils.copyProperties(orderInfoDetail,uporderInfoDetail,true);
      }
      return XfR.ok(orderInfoDetailServiceImpl.updateById(uporderInfoDetail));
  }

  /**
   * 通过id删除订单明细表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderinfodetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderInfoDetailServiceImpl.removeById(id));
  }

  @PostMapping("/orderinfodetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_info_detail");
     params.put("request", condition);

     return XfR.ok(orderInfoDetailServiceImpl.querys(params));
  }

}
