package com.xforceplus.ultraman.app.jcseazen.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcseazen.entity.BillCheckInterface;
import com.xforceplus.ultraman.app.jcseazen.service.IBillCheckInterfaceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-10-14
 */
@RestController
public class BillCheckInterfaceController {

  @Autowired
  private IBillCheckInterfaceService billCheckInterfaceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billCheckInterface ${table.comment}
   * @return
   */
  @GetMapping("/billcheckinterfaces" )
  public XfR getBillCheckInterfaces(XfPage page, BillCheckInterface billCheckInterface) {
    return XfR.ok(billCheckInterfaceServiceImpl.page(page, Wrappers.query(billCheckInterface)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billcheckinterfaces/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billCheckInterfaceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billCheckInterface ${table.comment}
   * @return XfR
   */
  @PostMapping("/billcheckinterfaces")
  public XfR save(@RequestBody BillCheckInterface billCheckInterface) {
     return XfR.ok(billCheckInterfaceServiceImpl.save(billCheckInterface));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billCheckInterface ${table.comment}
   * @return XfR
   */
  @PutMapping("/billcheckinterfaces/{id}")
  public XfR putUpdate(@RequestBody BillCheckInterface billCheckInterface,@PathVariable Long id) {
      billCheckInterface.setId(id);
      return XfR.ok(billCheckInterfaceServiceImpl.updateById(billCheckInterface));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billCheckInterface ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billcheckinterfaces/{id}")
  public XfR patchUpdate(@RequestBody BillCheckInterface billCheckInterface,@PathVariable Long id) {
      BillCheckInterface upbillCheckInterface = billCheckInterfaceServiceImpl.getById(id);
      if(upbillCheckInterface != null){
        upbillCheckInterface = ObjectCopyUtils.copyProperties(billCheckInterface,upbillCheckInterface,true);
      }
      return XfR.ok(billCheckInterfaceServiceImpl.updateById(upbillCheckInterface));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billcheckinterfaces/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billCheckInterfaceServiceImpl.removeById(id));
  }

  @PostMapping("/billcheckinterfaces/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_check_interface");
     params.put("request", condition);

     return XfR.ok(billCheckInterfaceServiceImpl.querys(params));
  }

}
