package com.xforceplus.ultraman.app.jcsmec.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2023-12-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcsmec.entity.SalesMaterialItem;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-smec")
public interface SalesMaterialItemFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/salesMaterialItem/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param salesMaterialItem ${table.comment}
   * @return R
   */
  @PostMapping("/salesMaterialItem/add")
  public R save(@RequestBody SalesMaterialItem salesMaterialItem);

  /**
   * 修改${table.comment}
   * @param salesMaterialItem ${table.comment}
   * @return R
   */
  @PostMapping("/salesMaterialItem/update")
  public R updateById(@RequestBody SalesMaterialItem salesMaterialItem);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/salesMaterialItem/del/{id}" )
  public R removeById(@PathVariable Long id);

}