package com.xforceplus.ultraman.app.jcsmec.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_type
 * </p>
 *
 * @author ultraman
 * @since 2023-12-05
 */
public enum InvoiceType {

    S("s", "增值税专用发票"),
    SE("se", "增值税电子专用发票"),
    C("c", "增值税普通发票"),
    CE("ce", "增值税电子普通发票"),
    QS("qs", "数电增值税电子专用发票"),
    QC("qc", "数电增值税电子普通发票"),
    SZ("sz", "数电增值税纸质专用发票"),
    CZ("cz", "数电增值税纸质普通发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "se":
                return SE;
            case "c":
                return C;
            case "ce":
                return CE;
            case "qs":
                return QS;
            case "qc":
                return QC;
            case "sz":
                return SZ;
            case "cz":
                return CZ;
            default:
                return null;
        }
    }
}
