package com.xforceplus.ultraman.app.jcsmec.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 下发优先级
 * </p>
 *
 * @author ultraman
 * @since 2022-09-19
 */
public enum SendPriority {

    ADVANCE_PAYMENT("advancePayment", "提前付款"),
    PAPER_DREW_DATE("paperDrewDate", "开票日期");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SendPriority(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SendPriority fromCode(String code){
        switch(code) {
            case "advancePayment":
                return ADVANCE_PAYMENT;
            case "paperDrewDate":
                return PAPER_DREW_DATE;
            default:
                return null;
        }
    }
}
