package com.xforceplus.ultraman.app.jcsmec.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * match_batch
 * </p>
 *
 * @author ultraman
 * @since 2022-11-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MatchBatch implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 批次号
   */
  private String batchNo;
  /**
   * 记账状态
   */
  private String bookStatus;
  /**
   * 记账时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime bookTime;
  /**
   * 锁定状态
   */
  private String lockStatus;
  /**
   * 锁定时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lockTime;
  /**
   * 下发状态
   */
  private String sendStatus;
  /**
   * 下发时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sendTime;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 购方公司编号
   */
  private String purchaserNo;
  /**
   * 购方公司税号
   */
  private String purchaserTaxNo;
  /**
   * 购方公司名称
   */
  private String purchaserName;
  /**
   * 销方公司编号
   */
  private String sellerNo;
  /**
   * 销方公司税号
   */
  private String sellerTaxNo;
  /**
   * 销方公司名称
   */
  private String sellerName;
  /**
   * 采购组织编码
   */
  private String purGroupNo;
  /**
   * 采购组织名称
   */
  private String purGroupName;
  /**
   * 发票数量
   */
  private Long invNum;
  /**
   * 业务单数量
   */
  private Long saleNum;
  /**
   * 配单状态
   */
  private String matchStatus;
  /**
   * 协同状态
   */
  private String antStatus;
  /**
   * 记账凭证号
   */
  private String accountingVoucherNo;
  /**
   * 预制凭证号
   */
  private String preVoucherNo;
  /**
   * 发票合计不含税金额
   */
  private BigDecimal sumAmount;
  /**
   * 备注
   */
  private String remark;
  /**
   * 折扣总金额
   */
  private BigDecimal discountAmount;
  /**
   * 回款周期
   */
  private Long collectionCycle;
  /**
   * 折扣率
   */
  private BigDecimal discountRate;
  /**
   * 是否包含折扣发票
   */
  private Boolean isDiscount;
  /**
   * 开票日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paperDrewDate;
  /**
   * 记账备注
   */
  private String bookRemark;
  /**
   * 锁定备注
   */
  private String lockRemark;
  /**
   * 发票号码
   */
  private String invoiceNos;
  /**
   * 采购订单号
   */
  private String purchaserNos;
  /**
   * 装运通知单
   */
  private String shippingNotices;
  /**
   * 合计物料凭证不含税金额
   */
  private BigDecimal materialAmountSum;
  /**
   * 未计划交货金额
   */
  private BigDecimal unplannedDeliveryAmount;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("batchNo", batchNo);
      map.put("bookStatus", bookStatus);
      map.put("bookTime", BocpGenUtils.toTimestamp(bookTime));
      map.put("lockStatus", lockStatus);
      map.put("lockTime", BocpGenUtils.toTimestamp(lockTime));
      map.put("sendStatus", sendStatus);
      map.put("sendTime", BocpGenUtils.toTimestamp(sendTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("purchaserNo", purchaserNo);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserName", purchaserName);
      map.put("sellerNo", sellerNo);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerName", sellerName);
      map.put("purGroupNo", purGroupNo);
      map.put("purGroupName", purGroupName);
      map.put("invNum", invNum);
      map.put("saleNum", saleNum);
      map.put("matchStatus", matchStatus);
      map.put("antStatus", antStatus);
      map.put("accountingVoucherNo", accountingVoucherNo);
      map.put("preVoucherNo", preVoucherNo);
      map.put("sumAmount", sumAmount);
      map.put("remark", remark);
      map.put("discountAmount", discountAmount);
      map.put("collectionCycle", collectionCycle);
      map.put("discountRate", discountRate);
      map.put("isDiscount", isDiscount);
      map.put("paperDrewDate", BocpGenUtils.toTimestamp(paperDrewDate));
      map.put("bookRemark", bookRemark);
      map.put("lockRemark", lockRemark);
      map.put("invoiceNos", invoiceNos);
      map.put("purchaserNos", purchaserNos);
      map.put("shippingNotices", shippingNotices);
      map.put("materialAmountSum", materialAmountSum);
      map.put("unplannedDeliveryAmount", unplannedDeliveryAmount);

      return map;
  }

  public static MatchBatch fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    MatchBatch entity = new MatchBatch();

    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bookStatus")) {
      Object obj = map.get("bookStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBookStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bookTime")) {
      Object obj = map.get("bookTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBookTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBookTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBookTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBookTime(null);
      }
    }
    if(map.containsKey("lockStatus")) {
      Object obj = map.get("lockStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLockStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lockTime")) {
      Object obj = map.get("lockTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLockTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setLockTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLockTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLockTime(null);
      }
    }
    if(map.containsKey("sendStatus")) {
      Object obj = map.get("sendStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSendStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendTime")) {
      Object obj = map.get("sendTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSendTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSendTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSendTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSendTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purGroupNo")) {
      Object obj = map.get("purGroupNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurGroupNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purGroupName")) {
      Object obj = map.get("purGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invNum")) {
      Object obj = map.get("invNum");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("saleNum")) {
      Object obj = map.get("saleNum");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSaleNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSaleNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSaleNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("matchStatus")) {
      Object obj = map.get("matchStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("antStatus")) {
      Object obj = map.get("antStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAntStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountingVoucherNo")) {
      Object obj = map.get("accountingVoucherNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountingVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preVoucherNo")) {
      Object obj = map.get("preVoucherNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPreVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sumAmount")) {
      Object obj = map.get("sumAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSumAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSumAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSumAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSumAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSumAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountAmount")) {
      Object obj = map.get("discountAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("collectionCycle")) {
      Object obj = map.get("collectionCycle");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectionCycle((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCollectionCycle(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCollectionCycle(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("isDiscount")) {
      Object obj = map.get("isDiscount");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsDiscount((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsDiscount(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaperDrewDate(null);
      }
    }
    if(map.containsKey("bookRemark")) {
      Object obj = map.get("bookRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBookRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lockRemark")) {
      Object obj = map.get("lockRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLockRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNos")) {
      Object obj = map.get("invoiceNos");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNos((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNos")) {
      Object obj = map.get("purchaserNos");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserNos((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippingNotices")) {
      Object obj = map.get("shippingNotices");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShippingNotices((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialAmountSum")) {
      Object obj = map.get("materialAmountSum");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMaterialAmountSum((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMaterialAmountSum(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMaterialAmountSum(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMaterialAmountSum(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMaterialAmountSum(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unplannedDeliveryAmount")) {
      Object obj = map.get("unplannedDeliveryAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnplannedDeliveryAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnplannedDeliveryAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnplannedDeliveryAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnplannedDeliveryAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnplannedDeliveryAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bookStatus")) {
      Object obj = map.get("bookStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBookStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bookTime")) {
      Object obj = map.get("bookTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBookTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setBookTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBookTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setBookTime(null);
      }
    }
    if(map.containsKey("lockStatus")) {
      Object obj = map.get("lockStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLockStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lockTime")) {
      Object obj = map.get("lockTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setLockTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setLockTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLockTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setLockTime(null);
      }
    }
    if(map.containsKey("sendStatus")) {
      Object obj = map.get("sendStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSendStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendTime")) {
      Object obj = map.get("sendTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSendTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSendTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSendTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSendTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purGroupNo")) {
      Object obj = map.get("purGroupNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurGroupNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purGroupName")) {
      Object obj = map.get("purGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invNum")) {
      Object obj = map.get("invNum");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInvNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setInvNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("saleNum")) {
      Object obj = map.get("saleNum");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSaleNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSaleNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSaleNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("matchStatus")) {
      Object obj = map.get("matchStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("antStatus")) {
      Object obj = map.get("antStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAntStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountingVoucherNo")) {
      Object obj = map.get("accountingVoucherNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountingVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preVoucherNo")) {
      Object obj = map.get("preVoucherNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPreVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sumAmount")) {
      Object obj = map.get("sumAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSumAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSumAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSumAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSumAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSumAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountAmount")) {
      Object obj = map.get("discountAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiscountAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiscountAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiscountAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiscountAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiscountAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("collectionCycle")) {
      Object obj = map.get("collectionCycle");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCollectionCycle((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCollectionCycle(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCollectionCycle(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("isDiscount")) {
      Object obj = map.get("isDiscount");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsDiscount((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsDiscount(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPaperDrewDate(null);
      }
    }
    if(map.containsKey("bookRemark")) {
      Object obj = map.get("bookRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBookRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lockRemark")) {
      Object obj = map.get("lockRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLockRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNos")) {
      Object obj = map.get("invoiceNos");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNos((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNos")) {
      Object obj = map.get("purchaserNos");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserNos((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippingNotices")) {
      Object obj = map.get("shippingNotices");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShippingNotices((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialAmountSum")) {
      Object obj = map.get("materialAmountSum");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setMaterialAmountSum((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setMaterialAmountSum(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setMaterialAmountSum(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMaterialAmountSum(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setMaterialAmountSum(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unplannedDeliveryAmount")) {
      Object obj = map.get("unplannedDeliveryAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnplannedDeliveryAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnplannedDeliveryAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnplannedDeliveryAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUnplannedDeliveryAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnplannedDeliveryAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
  }
}
