package com.xforceplus.ultraman.app.jcsmec.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2022-11-23
*/
public class EntityMeta {
    public interface OqsengineSdkOmAuditLog {
        static Long id() {
            return 1560140615658770433L;
        }
        static String code() {
            return "oqsengineSdkOmAuditLog";
        }
        TypedField<Long> OPERATOR_ID = new TypedField<>(Long.class, "operator_id");
        TypedField<String> OPERATOR_CODE = new TypedField<>(String.class, "operator_code");
        TypedField<String> OPERATOR_NAME = new TypedField<>(String.class, "operator_name");
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operate_type");
        TypedField<LocalDateTime> OPERATE_TIME = new TypedField<>(LocalDateTime.class, "operate_time");
        TypedField<Long> APP_ID = new TypedField<>(Long.class, "app_id");
        TypedField<String> APP_CODE = new TypedField<>(String.class, "app_code");
        TypedField<Long> BO_ID = new TypedField<>(Long.class, "bo_id");
        TypedField<String> BO_CODE = new TypedField<>(String.class, "bo_code");
        TypedField<String> BO_NAME = new TypedField<>(String.class, "bo_name");
        TypedField<Long> ENTITY_ID = new TypedField<>(Long.class, "entity_id");
        TypedField<String> REQUEST_DATA = new TypedField<>(String.class, "request_data");
        TypedField<String> RESPONSE_DATA = new TypedField<>(String.class, "response_data");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface InvQuotaConfig {
        static Long id() {
            return 1567037551564353538L;
        }
        static String code() {
            return "invQuotaConfig";
        }
        TypedField<BigDecimal> TOTAL_AMOUNT = new TypedField<>(BigDecimal.class, "totalAmount");
        TypedField<BigDecimal> SUM_AMOUNT = new TypedField<>(BigDecimal.class, "sumAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> SG_AMOUNT = new TypedField<>(BigDecimal.class, "sgAmount");
        TypedField<BigDecimal> SY_AMOUNT = new TypedField<>(BigDecimal.class, "syAmount");
        TypedField<String> YEAR_MONTH = new TypedField<>(String.class, "yearMonth");
        /**
         * 对一关联关系 关联对象 company
         */
        TypedField<Long> COMPANY_AND_INV_QUOTA_CONFIG_ID = new TypedField<>(Long.class, "companyAndInvQuotaConfig.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface COMPANY_AND_INV_QUOTA_CONFIG {
                static String code () {
                    return "companyAndInvQuotaConfig" ;
                }
                TypedField<String> COMPANY_NO = new TypedField<>(String.class, "companyAndInvQuotaConfig.companyNo");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyAndInvQuotaConfig.companyName");
                TypedField<String> COMPANY_TAX_NO = new TypedField<>(String.class, "companyAndInvQuotaConfig.companyTaxNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "companyAndInvQuotaConfig.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "companyAndInvQuotaConfig.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "companyAndInvQuotaConfig.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "companyAndInvQuotaConfig.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "companyAndInvQuotaConfig.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "companyAndInvQuotaConfig.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "companyAndInvQuotaConfig.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "companyAndInvQuotaConfig.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "companyAndInvQuotaConfig.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "companyAndInvQuotaConfig.delete_flag");
                TypedField<Boolean> AMT_ENABLE = new TypedField<>(Boolean.class, "companyAndInvQuotaConfig.amtEnable");
                TypedField<Boolean> EMAIL_ENABLE = new TypedField<>(Boolean.class, "companyAndInvQuotaConfig.emailEnable");
                TypedField<Boolean> PRIORITY_ENABLE = new TypedField<>(Boolean.class, "companyAndInvQuotaConfig.priorityEnable");
            }
        }
    }
    public interface InvEmailConfig {
        static Long id() {
            return 1567077639257792514L;
        }
        static String code() {
            return "invEmailConfig";
        }
        TypedField<String> EMAIL = new TypedField<>(String.class, "email");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PUR_GROUP_NO = new TypedField<>(String.class, "purGroupNo");
        TypedField<String> PUR_GROUP_NAME = new TypedField<>(String.class, "purGroupName");
        /**
         * 对一关联关系 关联对象 company
         */
        TypedField<Long> COMPANY_AND_INV_EMAIL_CONFIG_ID = new TypedField<>(Long.class, "companyAndInvEmailConfig.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface COMPANY_AND_INV_EMAIL_CONFIG {
                static String code () {
                    return "companyAndInvEmailConfig" ;
                }
                TypedField<String> COMPANY_NO = new TypedField<>(String.class, "companyAndInvEmailConfig.companyNo");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyAndInvEmailConfig.companyName");
                TypedField<String> COMPANY_TAX_NO = new TypedField<>(String.class, "companyAndInvEmailConfig.companyTaxNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "companyAndInvEmailConfig.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "companyAndInvEmailConfig.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "companyAndInvEmailConfig.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "companyAndInvEmailConfig.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "companyAndInvEmailConfig.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "companyAndInvEmailConfig.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "companyAndInvEmailConfig.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "companyAndInvEmailConfig.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "companyAndInvEmailConfig.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "companyAndInvEmailConfig.delete_flag");
                TypedField<Boolean> AMT_ENABLE = new TypedField<>(Boolean.class, "companyAndInvEmailConfig.amtEnable");
                TypedField<Boolean> EMAIL_ENABLE = new TypedField<>(Boolean.class, "companyAndInvEmailConfig.emailEnable");
                TypedField<Boolean> PRIORITY_ENABLE = new TypedField<>(Boolean.class, "companyAndInvEmailConfig.priorityEnable");
            }
        }
    }
    public interface MatchBatch {
        static Long id() {
            return 1567343577951363074L;
        }
        static String code() {
            return "matchBatch";
        }
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batchNo");
        TypedField<String> BOOK_STATUS = new TypedField<>(String.class, "bookStatus");
        TypedField<LocalDateTime> BOOK_TIME = new TypedField<>(LocalDateTime.class, "bookTime");
        TypedField<String> LOCK_STATUS = new TypedField<>(String.class, "lockStatus");
        TypedField<LocalDateTime> LOCK_TIME = new TypedField<>(LocalDateTime.class, "lockTime");
        TypedField<String> SEND_STATUS = new TypedField<>(String.class, "sendStatus");
        TypedField<LocalDateTime> SEND_TIME = new TypedField<>(LocalDateTime.class, "sendTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> PUR_GROUP_NO = new TypedField<>(String.class, "purGroupNo");
        TypedField<String> PUR_GROUP_NAME = new TypedField<>(String.class, "purGroupName");
        TypedField<Long> INV_NUM = new TypedField<>(Long.class, "invNum");
        TypedField<Long> SALE_NUM = new TypedField<>(Long.class, "saleNum");
        TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "matchStatus");
        TypedField<String> ANT_STATUS = new TypedField<>(String.class, "antStatus");
        TypedField<String> ACCOUNTING_VOUCHER_NO = new TypedField<>(String.class, "accountingVoucherNo");
        TypedField<String> PRE_VOUCHER_NO = new TypedField<>(String.class, "preVoucherNo");
        TypedField<BigDecimal> SUM_AMOUNT = new TypedField<>(BigDecimal.class, "sumAmount");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<BigDecimal> DISCOUNT_AMOUNT = new TypedField<>(BigDecimal.class, "discountAmount");
        TypedField<Long> COLLECTION_CYCLE = new TypedField<>(Long.class, "collectionCycle");
        TypedField<BigDecimal> DISCOUNT_RATE = new TypedField<>(BigDecimal.class, "discountRate");
        TypedField<Boolean> IS_DISCOUNT = new TypedField<>(Boolean.class, "isDiscount");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paperDrewDate");
        TypedField<String> BOOK_REMARK = new TypedField<>(String.class, "bookRemark");
        TypedField<String> LOCK_REMARK = new TypedField<>(String.class, "lockRemark");
        TypedField<String> INVOICE_NOS = new TypedField<>(String.class, "invoiceNos");
        TypedField<String> PURCHASER_NOS = new TypedField<>(String.class, "purchaserNos");
        TypedField<String> SHIPPING_NOTICES = new TypedField<>(String.class, "shippingNotices");
        TypedField<BigDecimal> MATERIAL_AMOUNT_SUM = new TypedField<>(BigDecimal.class, "materialAmountSum");
        TypedField<BigDecimal> UNPLANNED_DELIVERY_AMOUNT = new TypedField<>(BigDecimal.class, "unplannedDeliveryAmount");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface InvoiceMain {
        static Long id() {
            return 1567373342265778177L;
        }
        static String code() {
            return "invoiceMain";
        }
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paperDrewDate");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "scanTime");
        TypedField<String> IMAGE_URL = new TypedField<>(String.class, "imageUrl");
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbillNo");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlementNo");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT13 = new TypedField<>(String.class, "ext13");
        TypedField<String> EXT14 = new TypedField<>(String.class, "ext14");
        TypedField<String> EXT15 = new TypedField<>(String.class, "ext15");
        TypedField<String> EXT16 = new TypedField<>(String.class, "ext16");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> EXT18 = new TypedField<>(String.class, "ext18");
        TypedField<String> EXT19 = new TypedField<>(String.class, "ext19");
        TypedField<String> EXT20 = new TypedField<>(String.class, "ext20");
        TypedField<String> EXT21 = new TypedField<>(String.class, "ext21");
        TypedField<String> EXT22 = new TypedField<>(String.class, "ext22");
        TypedField<String> EXT23 = new TypedField<>(String.class, "ext23");
        TypedField<String> EXT24 = new TypedField<>(String.class, "ext24");
        TypedField<String> EXT25 = new TypedField<>(String.class, "ext25");
        TypedField<String> RED_STATUS = new TypedField<>(String.class, "redStatus");
        /**
         * 对一关联关系 关联对象 matchBatch
         */
        TypedField<Long> MATCH_BATCH_AND_INVOICE_MAIN_ID = new TypedField<>(Long.class, "matchBatchAndInvoiceMain.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface MATCH_BATCH_AND_INVOICE_MAIN {
                static String code () {
                    return "matchBatchAndInvoiceMain" ;
                }
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "matchBatchAndInvoiceMain.batchNo");
                TypedField<String> BOOK_STATUS = new TypedField<>(String.class, "matchBatchAndInvoiceMain.bookStatus");
                TypedField<LocalDateTime> BOOK_TIME = new TypedField<>(LocalDateTime.class, "matchBatchAndInvoiceMain.bookTime");
                TypedField<String> LOCK_STATUS = new TypedField<>(String.class, "matchBatchAndInvoiceMain.lockStatus");
                TypedField<LocalDateTime> LOCK_TIME = new TypedField<>(LocalDateTime.class, "matchBatchAndInvoiceMain.lockTime");
                TypedField<String> SEND_STATUS = new TypedField<>(String.class, "matchBatchAndInvoiceMain.sendStatus");
                TypedField<LocalDateTime> SEND_TIME = new TypedField<>(LocalDateTime.class, "matchBatchAndInvoiceMain.sendTime");
                TypedField<Long> ID = new TypedField<>(Long.class, "matchBatchAndInvoiceMain.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "matchBatchAndInvoiceMain.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "matchBatchAndInvoiceMain.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "matchBatchAndInvoiceMain.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "matchBatchAndInvoiceMain.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "matchBatchAndInvoiceMain.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "matchBatchAndInvoiceMain.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "matchBatchAndInvoiceMain.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "matchBatchAndInvoiceMain.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "matchBatchAndInvoiceMain.delete_flag");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "matchBatchAndInvoiceMain.purchaserNo");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "matchBatchAndInvoiceMain.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "matchBatchAndInvoiceMain.purchaserName");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "matchBatchAndInvoiceMain.sellerNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "matchBatchAndInvoiceMain.sellerTaxNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "matchBatchAndInvoiceMain.sellerName");
                TypedField<String> PUR_GROUP_NO = new TypedField<>(String.class, "matchBatchAndInvoiceMain.purGroupNo");
                TypedField<String> PUR_GROUP_NAME = new TypedField<>(String.class, "matchBatchAndInvoiceMain.purGroupName");
                TypedField<Long> INV_NUM = new TypedField<>(Long.class, "matchBatchAndInvoiceMain.invNum");
                TypedField<Long> SALE_NUM = new TypedField<>(Long.class, "matchBatchAndInvoiceMain.saleNum");
                TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "matchBatchAndInvoiceMain.matchStatus");
                TypedField<String> ANT_STATUS = new TypedField<>(String.class, "matchBatchAndInvoiceMain.antStatus");
                TypedField<String> ACCOUNTING_VOUCHER_NO = new TypedField<>(String.class, "matchBatchAndInvoiceMain.accountingVoucherNo");
                TypedField<String> PRE_VOUCHER_NO = new TypedField<>(String.class, "matchBatchAndInvoiceMain.preVoucherNo");
                TypedField<BigDecimal> SUM_AMOUNT = new TypedField<>(BigDecimal.class, "matchBatchAndInvoiceMain.sumAmount");
                TypedField<String> REMARK = new TypedField<>(String.class, "matchBatchAndInvoiceMain.remark");
                TypedField<BigDecimal> DISCOUNT_AMOUNT = new TypedField<>(BigDecimal.class, "matchBatchAndInvoiceMain.discountAmount");
                TypedField<Long> COLLECTION_CYCLE = new TypedField<>(Long.class, "matchBatchAndInvoiceMain.collectionCycle");
                TypedField<BigDecimal> DISCOUNT_RATE = new TypedField<>(BigDecimal.class, "matchBatchAndInvoiceMain.discountRate");
                TypedField<Boolean> IS_DISCOUNT = new TypedField<>(Boolean.class, "matchBatchAndInvoiceMain.isDiscount");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "matchBatchAndInvoiceMain.paperDrewDate");
                TypedField<String> BOOK_REMARK = new TypedField<>(String.class, "matchBatchAndInvoiceMain.bookRemark");
                TypedField<String> LOCK_REMARK = new TypedField<>(String.class, "matchBatchAndInvoiceMain.lockRemark");
                TypedField<String> INVOICE_NOS = new TypedField<>(String.class, "matchBatchAndInvoiceMain.invoiceNos");
                TypedField<String> PURCHASER_NOS = new TypedField<>(String.class, "matchBatchAndInvoiceMain.purchaserNos");
                TypedField<String> SHIPPING_NOTICES = new TypedField<>(String.class, "matchBatchAndInvoiceMain.shippingNotices");
                TypedField<BigDecimal> MATERIAL_AMOUNT_SUM = new TypedField<>(BigDecimal.class, "matchBatchAndInvoiceMain.materialAmountSum");
                TypedField<BigDecimal> UNPLANNED_DELIVERY_AMOUNT = new TypedField<>(BigDecimal.class, "matchBatchAndInvoiceMain.unplannedDeliveryAmount");
            }
        }
    }
    public interface SalesMaterialItem {
        static Long id() {
            return 1567376162677055490L;
        }
        static String code() {
            return "salesMaterialItem";
        }
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> MATERIAL_VOUCHER_LINE_ITEM = new TypedField<>(String.class, "materialVoucherLineItem");
        TypedField<String> YEAR = new TypedField<>(String.class, "year");
        TypedField<String> MATERIAL_VOUCHER = new TypedField<>(String.class, "materialVoucher");
        TypedField<String> LINE_ITEM = new TypedField<>(String.class, "lineItem");
        TypedField<String> PURCHASE_ORDER = new TypedField<>(String.class, "purchaseOrder");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantityUnit");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> MATERIAL = new TypedField<>(String.class, "material");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SHIPPING_NOTICE = new TypedField<>(String.class, "shippingNotice");
        TypedField<String> INBOUND_DELIVERY = new TypedField<>(String.class, "inboundDelivery");
        TypedField<String> ORDER_LINE_ITEM = new TypedField<>(String.class, "orderLineItem");
        TypedField<String> PURCHASING_GROUP_NO = new TypedField<>(String.class, "purchasingGroupNo");
        TypedField<String> FLOW_STATUS = new TypedField<>(String.class, "flowStatus");
        TypedField<String> SALES_TYPE = new TypedField<>(String.class, "salesType");
        TypedField<String> SALES_BILL_NO = new TypedField<>(String.class, "salesBillNo");
        TypedField<String> ABSENT_MESSAGE = new TypedField<>(String.class, "absentMessage");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<BigDecimal> NET_PRICE = new TypedField<>(BigDecimal.class, "netPrice");
        TypedField<String> SERVICE_ENTRY = new TypedField<>(String.class, "serviceEntry");
        TypedField<String> MATERIAL_DESCRIBE = new TypedField<>(String.class, "materialDescribe");
        TypedField<String> MATERIAL_NO = new TypedField<>(String.class, "materialNo");
        TypedField<String> SUPPLIER_NO = new TypedField<>(String.class, "supplierNo");
        TypedField<String> COMPANY_NO = new TypedField<>(String.class, "companyNo");
        TypedField<String> SALES_TYPE_DESC = new TypedField<>(String.class, "salesTypeDesc");
        /**
         * 对一关联关系 关联对象 salesMaterial
         */
        TypedField<Long> SALES_MATERIAL_AND_ITEM_ID = new TypedField<>(Long.class, "salesMaterialAndItem.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface SALES_MATERIAL_AND_ITEM {
                static String code () {
                    return "salesMaterialAndItem" ;
                }
                TypedField<String> YEAR = new TypedField<>(String.class, "salesMaterialAndItem.year");
                TypedField<String> MATERIAL_VOUCHER = new TypedField<>(String.class, "salesMaterialAndItem.materialVoucher");
                TypedField<String> PURCHASE_ORDER = new TypedField<>(String.class, "salesMaterialAndItem.purchaseOrder");
                TypedField<String> SHIPPING_NOTICE = new TypedField<>(String.class, "salesMaterialAndItem.shippingNotice");
                TypedField<String> PURCHASING_GROUP_NO = new TypedField<>(String.class, "salesMaterialAndItem.purchasingGroupNo");
                TypedField<String> SALES_TYPE = new TypedField<>(String.class, "salesMaterialAndItem.salesType");
                TypedField<String> SALES_BILL_NO = new TypedField<>(String.class, "salesMaterialAndItem.salesBillNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "salesMaterialAndItem.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "salesMaterialAndItem.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "salesMaterialAndItem.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "salesMaterialAndItem.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "salesMaterialAndItem.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "salesMaterialAndItem.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "salesMaterialAndItem.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "salesMaterialAndItem.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "salesMaterialAndItem.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "salesMaterialAndItem.delete_flag");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "salesMaterialAndItem.amountWithTax");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "salesMaterialAndItem.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "salesMaterialAndItem.taxAmount");
                TypedField<String> SUPPLIER_NO = new TypedField<>(String.class, "salesMaterialAndItem.supplierNo");
                TypedField<String> COMPANY_NO = new TypedField<>(String.class, "salesMaterialAndItem.companyNo");
                TypedField<String> SALES_TYPE_DESC = new TypedField<>(String.class, "salesMaterialAndItem.salesTypeDesc");
            }
        }
    }
    public interface Company {
        static Long id() {
            return 1567436977170014209L;
        }
        static String code() {
            return "company";
        }
        TypedField<String> COMPANY_NO = new TypedField<>(String.class, "companyNo");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_TAX_NO = new TypedField<>(String.class, "companyTaxNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Boolean> AMT_ENABLE = new TypedField<>(Boolean.class, "amtEnable");
        TypedField<Boolean> EMAIL_ENABLE = new TypedField<>(Boolean.class, "emailEnable");
        TypedField<Boolean> PRIORITY_ENABLE = new TypedField<>(Boolean.class, "priorityEnable");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface InvPriorityConfig {
        static Long id() {
            return 1567508798036762625L;
        }
        static String code() {
            return "invPriorityConfig";
        }
        TypedField<Long> PRIORITY = new TypedField<>(Long.class, "priority");
        TypedField<String> SEND_PRIORITY = new TypedField<>(String.class, "sendPriority");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 company
         */
        TypedField<Long> COMPANY_AND_INV_PRIORITY_CONFIG_ID = new TypedField<>(Long.class, "companyAndInvPriorityConfig.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface COMPANY_AND_INV_PRIORITY_CONFIG {
                static String code () {
                    return "companyAndInvPriorityConfig" ;
                }
                TypedField<String> COMPANY_NO = new TypedField<>(String.class, "companyAndInvPriorityConfig.companyNo");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyAndInvPriorityConfig.companyName");
                TypedField<String> COMPANY_TAX_NO = new TypedField<>(String.class, "companyAndInvPriorityConfig.companyTaxNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "companyAndInvPriorityConfig.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "companyAndInvPriorityConfig.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "companyAndInvPriorityConfig.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "companyAndInvPriorityConfig.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "companyAndInvPriorityConfig.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "companyAndInvPriorityConfig.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "companyAndInvPriorityConfig.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "companyAndInvPriorityConfig.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "companyAndInvPriorityConfig.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "companyAndInvPriorityConfig.delete_flag");
                TypedField<Boolean> AMT_ENABLE = new TypedField<>(Boolean.class, "companyAndInvPriorityConfig.amtEnable");
                TypedField<Boolean> EMAIL_ENABLE = new TypedField<>(Boolean.class, "companyAndInvPriorityConfig.emailEnable");
                TypedField<Boolean> PRIORITY_ENABLE = new TypedField<>(Boolean.class, "companyAndInvPriorityConfig.priorityEnable");
            }
        }
    }
    public interface InvoiceDetail {
        static Long id() {
            return 1569251953684312065L;
        }
        static String code() {
            return "invoiceDetail";
        }
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> CARGO_CODE = new TypedField<>(String.class, "cargoCode");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "itemName");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "itemSpec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantityUnit");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "discountWithoutTax");
        TypedField<BigDecimal> DISCOUNT_TAX = new TypedField<>(BigDecimal.class, "discountTax");
        TypedField<BigDecimal> DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "discountWithTax");
        TypedField<BigDecimal> DISCOUNT_RATE = new TypedField<>(BigDecimal.class, "discountRate");
        TypedField<String> TAX_ITEM = new TypedField<>(String.class, "taxItem");
        TypedField<String> GOODS_NO_VER = new TypedField<>(String.class, "goodsNoVer");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsTaxNo");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "taxPre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "taxPreCon");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zeroTax");
        TypedField<String> DISCOUNT_FLAG = new TypedField<>(String.class, "discountFlag");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "priceMethod");
        TypedField<String> DEDUCTION = new TypedField<>(String.class, "deduction");
        TypedField<String> PRINT_CONTENT_FLAG = new TypedField<>(String.class, "printContentFlag");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT13 = new TypedField<>(String.class, "ext13");
        TypedField<String> EXT14 = new TypedField<>(String.class, "ext14");
        TypedField<String> EXT15 = new TypedField<>(String.class, "ext15");
        TypedField<String> EXT16 = new TypedField<>(String.class, "ext16");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> EXT18 = new TypedField<>(String.class, "ext18");
        TypedField<String> EXT19 = new TypedField<>(String.class, "ext19");
        TypedField<String> EXT20 = new TypedField<>(String.class, "ext20");
        TypedField<String> EXT21 = new TypedField<>(String.class, "ext21");
        TypedField<String> EXT22 = new TypedField<>(String.class, "ext22");
        TypedField<String> EXT23 = new TypedField<>(String.class, "ext23");
        TypedField<String> EXT24 = new TypedField<>(String.class, "ext24");
        TypedField<String> EXT25 = new TypedField<>(String.class, "ext25");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 invoiceMain
         */
        TypedField<Long> INVOICE_MAIN_AND_DETAIL_ID = new TypedField<>(Long.class, "invoiceMainAndDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_MAIN_AND_DETAIL {
                static String code () {
                    return "invoiceMainAndDetail" ;
                }
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceMainAndDetail.invoiceNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceMainAndDetail.invoiceCode");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "invoiceMainAndDetail.paperDrewDate");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceMainAndDetail.invoiceStatus");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceMainAndDetail.amountWithTax");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceMainAndDetail.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceMainAndDetail.taxAmount");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "invoiceMainAndDetail.taxRate");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceMainAndDetail.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceMainAndDetail.purchaserName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceMainAndDetail.sellerTaxNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceMainAndDetail.sellerName");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "invoiceMainAndDetail.scanTime");
                TypedField<String> IMAGE_URL = new TypedField<>(String.class, "invoiceMainAndDetail.imageUrl");
                TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "invoiceMainAndDetail.salesbillNo");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "invoiceMainAndDetail.settlementNo");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceMainAndDetail.invoiceType");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceMainAndDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceMainAndDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceMainAndDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceMainAndDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceMainAndDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceMainAndDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceMainAndDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceMainAndDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceMainAndDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceMainAndDetail.delete_flag");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceMainAndDetail.purchaserNo");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceMainAndDetail.sellerNo");
                TypedField<String> EXT1 = new TypedField<>(String.class, "invoiceMainAndDetail.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "invoiceMainAndDetail.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "invoiceMainAndDetail.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "invoiceMainAndDetail.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "invoiceMainAndDetail.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "invoiceMainAndDetail.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "invoiceMainAndDetail.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "invoiceMainAndDetail.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "invoiceMainAndDetail.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "invoiceMainAndDetail.ext10");
                TypedField<String> EXT11 = new TypedField<>(String.class, "invoiceMainAndDetail.ext11");
                TypedField<String> EXT12 = new TypedField<>(String.class, "invoiceMainAndDetail.ext12");
                TypedField<String> EXT13 = new TypedField<>(String.class, "invoiceMainAndDetail.ext13");
                TypedField<String> EXT14 = new TypedField<>(String.class, "invoiceMainAndDetail.ext14");
                TypedField<String> EXT15 = new TypedField<>(String.class, "invoiceMainAndDetail.ext15");
                TypedField<String> EXT16 = new TypedField<>(String.class, "invoiceMainAndDetail.ext16");
                TypedField<String> EXT17 = new TypedField<>(String.class, "invoiceMainAndDetail.ext17");
                TypedField<String> EXT18 = new TypedField<>(String.class, "invoiceMainAndDetail.ext18");
                TypedField<String> EXT19 = new TypedField<>(String.class, "invoiceMainAndDetail.ext19");
                TypedField<String> EXT20 = new TypedField<>(String.class, "invoiceMainAndDetail.ext20");
                TypedField<String> EXT21 = new TypedField<>(String.class, "invoiceMainAndDetail.ext21");
                TypedField<String> EXT22 = new TypedField<>(String.class, "invoiceMainAndDetail.ext22");
                TypedField<String> EXT23 = new TypedField<>(String.class, "invoiceMainAndDetail.ext23");
                TypedField<String> EXT24 = new TypedField<>(String.class, "invoiceMainAndDetail.ext24");
                TypedField<String> EXT25 = new TypedField<>(String.class, "invoiceMainAndDetail.ext25");
                TypedField<String> RED_STATUS = new TypedField<>(String.class, "invoiceMainAndDetail.redStatus");
            }
        }
    }
    public interface SalesBillMain {
        static Long id() {
            return 1569259513786867713L;
        }
        static String code() {
            return "salesBillMain";
        }
        TypedField<String> SALES_BILL_NO = new TypedField<>(String.class, "salesBillNo");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "priceMethod");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> INNER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "innerDiscountWithTax");
        TypedField<BigDecimal> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "innerDiscountWithoutTax");
        TypedField<BigDecimal> OUTTER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "outterDiscountWithTax");
        TypedField<BigDecimal> OUTTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "outterDiscountWithoutTax");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "receiveUserEmail");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT13 = new TypedField<>(String.class, "ext13");
        TypedField<String> EXT14 = new TypedField<>(String.class, "ext14");
        TypedField<String> EXT15 = new TypedField<>(String.class, "ext15");
        TypedField<String> EXT16 = new TypedField<>(String.class, "ext16");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> EXT18 = new TypedField<>(String.class, "ext18");
        TypedField<String> EXT19 = new TypedField<>(String.class, "ext19");
        TypedField<String> EXT20 = new TypedField<>(String.class, "ext20");
        TypedField<String> EXT21 = new TypedField<>(String.class, "ext21");
        TypedField<String> EXT22 = new TypedField<>(String.class, "ext22");
        TypedField<String> EXT23 = new TypedField<>(String.class, "ext23");
        TypedField<String> EXT24 = new TypedField<>(String.class, "ext24");
        TypedField<String> EXT25 = new TypedField<>(String.class, "ext25");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlementNo");
        /**
         * 对一关联关系 关联对象 matchBatch
         */
        TypedField<Long> MATCH_BATCH_AND_SALES_BILL_MAIN_ID = new TypedField<>(Long.class, "matchBatchAndSalesBillMain.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface MATCH_BATCH_AND_SALES_BILL_MAIN {
                static String code () {
                    return "matchBatchAndSalesBillMain" ;
                }
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "matchBatchAndSalesBillMain.batchNo");
                TypedField<String> BOOK_STATUS = new TypedField<>(String.class, "matchBatchAndSalesBillMain.bookStatus");
                TypedField<LocalDateTime> BOOK_TIME = new TypedField<>(LocalDateTime.class, "matchBatchAndSalesBillMain.bookTime");
                TypedField<String> LOCK_STATUS = new TypedField<>(String.class, "matchBatchAndSalesBillMain.lockStatus");
                TypedField<LocalDateTime> LOCK_TIME = new TypedField<>(LocalDateTime.class, "matchBatchAndSalesBillMain.lockTime");
                TypedField<String> SEND_STATUS = new TypedField<>(String.class, "matchBatchAndSalesBillMain.sendStatus");
                TypedField<LocalDateTime> SEND_TIME = new TypedField<>(LocalDateTime.class, "matchBatchAndSalesBillMain.sendTime");
                TypedField<Long> ID = new TypedField<>(Long.class, "matchBatchAndSalesBillMain.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "matchBatchAndSalesBillMain.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "matchBatchAndSalesBillMain.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "matchBatchAndSalesBillMain.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "matchBatchAndSalesBillMain.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "matchBatchAndSalesBillMain.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "matchBatchAndSalesBillMain.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "matchBatchAndSalesBillMain.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "matchBatchAndSalesBillMain.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "matchBatchAndSalesBillMain.delete_flag");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "matchBatchAndSalesBillMain.purchaserNo");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "matchBatchAndSalesBillMain.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "matchBatchAndSalesBillMain.purchaserName");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "matchBatchAndSalesBillMain.sellerNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "matchBatchAndSalesBillMain.sellerTaxNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "matchBatchAndSalesBillMain.sellerName");
                TypedField<String> PUR_GROUP_NO = new TypedField<>(String.class, "matchBatchAndSalesBillMain.purGroupNo");
                TypedField<String> PUR_GROUP_NAME = new TypedField<>(String.class, "matchBatchAndSalesBillMain.purGroupName");
                TypedField<Long> INV_NUM = new TypedField<>(Long.class, "matchBatchAndSalesBillMain.invNum");
                TypedField<Long> SALE_NUM = new TypedField<>(Long.class, "matchBatchAndSalesBillMain.saleNum");
                TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "matchBatchAndSalesBillMain.matchStatus");
                TypedField<String> ANT_STATUS = new TypedField<>(String.class, "matchBatchAndSalesBillMain.antStatus");
                TypedField<String> ACCOUNTING_VOUCHER_NO = new TypedField<>(String.class, "matchBatchAndSalesBillMain.accountingVoucherNo");
                TypedField<String> PRE_VOUCHER_NO = new TypedField<>(String.class, "matchBatchAndSalesBillMain.preVoucherNo");
                TypedField<BigDecimal> SUM_AMOUNT = new TypedField<>(BigDecimal.class, "matchBatchAndSalesBillMain.sumAmount");
                TypedField<String> REMARK = new TypedField<>(String.class, "matchBatchAndSalesBillMain.remark");
                TypedField<BigDecimal> DISCOUNT_AMOUNT = new TypedField<>(BigDecimal.class, "matchBatchAndSalesBillMain.discountAmount");
                TypedField<Long> COLLECTION_CYCLE = new TypedField<>(Long.class, "matchBatchAndSalesBillMain.collectionCycle");
                TypedField<BigDecimal> DISCOUNT_RATE = new TypedField<>(BigDecimal.class, "matchBatchAndSalesBillMain.discountRate");
                TypedField<Boolean> IS_DISCOUNT = new TypedField<>(Boolean.class, "matchBatchAndSalesBillMain.isDiscount");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "matchBatchAndSalesBillMain.paperDrewDate");
                TypedField<String> BOOK_REMARK = new TypedField<>(String.class, "matchBatchAndSalesBillMain.bookRemark");
                TypedField<String> LOCK_REMARK = new TypedField<>(String.class, "matchBatchAndSalesBillMain.lockRemark");
                TypedField<String> INVOICE_NOS = new TypedField<>(String.class, "matchBatchAndSalesBillMain.invoiceNos");
                TypedField<String> PURCHASER_NOS = new TypedField<>(String.class, "matchBatchAndSalesBillMain.purchaserNos");
                TypedField<String> SHIPPING_NOTICES = new TypedField<>(String.class, "matchBatchAndSalesBillMain.shippingNotices");
                TypedField<BigDecimal> MATERIAL_AMOUNT_SUM = new TypedField<>(BigDecimal.class, "matchBatchAndSalesBillMain.materialAmountSum");
                TypedField<BigDecimal> UNPLANNED_DELIVERY_AMOUNT = new TypedField<>(BigDecimal.class, "matchBatchAndSalesBillMain.unplannedDeliveryAmount");
            }
        }
    }
    public interface SalesBillItem {
        static Long id() {
            return 1569261595630039042L;
        }
        static String code() {
            return "salesBillItem";
        }
        TypedField<String> SALES_BILL_ITEM_NO = new TypedField<>(String.class, "salesBillItemNo");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "priceMethod");
        TypedField<String> TAX_CONVERT_CODE = new TypedField<>(String.class, "taxConvertCode");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "itemName");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantityUnit");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "itemSpec");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> INNER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "innerDiscountWithTax");
        TypedField<BigDecimal> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "innerDiscountWithoutTax");
        TypedField<BigDecimal> OUTTER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "outterDiscountWithTax");
        TypedField<BigDecimal> OUTTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "outterDiscountWithoutTax");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "taxPre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "taxPreCon");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zeroTax");
        TypedField<BigDecimal> INNER_DISCOUNT_TAX = new TypedField<>(BigDecimal.class, "innerDiscountTax");
        TypedField<BigDecimal> OUTTER_DISCOUNT_TAX = new TypedField<>(BigDecimal.class, "outterDiscountTax");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT13 = new TypedField<>(String.class, "ext13");
        TypedField<String> EXT14 = new TypedField<>(String.class, "ext14");
        TypedField<String> EXT15 = new TypedField<>(String.class, "ext15");
        TypedField<String> EXT16 = new TypedField<>(String.class, "ext16");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> EXT18 = new TypedField<>(String.class, "ext18");
        TypedField<String> EXT19 = new TypedField<>(String.class, "ext19");
        TypedField<String> EXT20 = new TypedField<>(String.class, "ext20");
        TypedField<String> EXT21 = new TypedField<>(String.class, "ext21");
        TypedField<String> EXT22 = new TypedField<>(String.class, "ext22");
        TypedField<String> EXT23 = new TypedField<>(String.class, "ext23");
        TypedField<String> EXT24 = new TypedField<>(String.class, "ext24");
        TypedField<String> EXT25 = new TypedField<>(String.class, "ext25");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<String> SALES_BILL_NO = new TypedField<>(String.class, "salesBillNo");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        /**
         * 对一关联关系 关联对象 salesBillMain
         */
        TypedField<Long> SALES_BILL_MAIN_AND_ITEM_ID = new TypedField<>(Long.class, "salesBillMainAndItem.id");
        /**
         * 对一关联关系 关联对象 matchBatch
         */
        TypedField<Long> MATCH_BATCH_AND_SALES_BILL_ITEM_ID = new TypedField<>(Long.class, "matchBatchAndSalesBillItem.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface SALES_BILL_MAIN_AND_ITEM {
                static String code () {
                    return "salesBillMainAndItem" ;
                }
                TypedField<String> SALES_BILL_NO = new TypedField<>(String.class, "salesBillMainAndItem.salesBillNo");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "salesBillMainAndItem.invoiceType");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "salesBillMainAndItem.sellerNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "salesBillMainAndItem.sellerName");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "salesBillMainAndItem.purchaserName");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "salesBillMainAndItem.purchaserTaxNo");
                TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "salesBillMainAndItem.priceMethod");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "salesBillMainAndItem.amountWithoutTax");
                TypedField<BigDecimal> INNER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "salesBillMainAndItem.innerDiscountWithTax");
                TypedField<BigDecimal> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "salesBillMainAndItem.innerDiscountWithoutTax");
                TypedField<BigDecimal> OUTTER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "salesBillMainAndItem.outterDiscountWithTax");
                TypedField<BigDecimal> OUTTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "salesBillMainAndItem.outterDiscountWithoutTax");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "salesBillMainAndItem.purchaserNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "salesBillMainAndItem.sellerTaxNo");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "salesBillMainAndItem.amountWithTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "salesBillMainAndItem.taxAmount");
                TypedField<String> REMARK = new TypedField<>(String.class, "salesBillMainAndItem.remark");
                TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "salesBillMainAndItem.receiveUserEmail");
                TypedField<String> EXT1 = new TypedField<>(String.class, "salesBillMainAndItem.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "salesBillMainAndItem.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "salesBillMainAndItem.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "salesBillMainAndItem.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "salesBillMainAndItem.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "salesBillMainAndItem.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "salesBillMainAndItem.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "salesBillMainAndItem.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "salesBillMainAndItem.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "salesBillMainAndItem.ext10");
                TypedField<String> EXT11 = new TypedField<>(String.class, "salesBillMainAndItem.ext11");
                TypedField<String> EXT12 = new TypedField<>(String.class, "salesBillMainAndItem.ext12");
                TypedField<String> EXT13 = new TypedField<>(String.class, "salesBillMainAndItem.ext13");
                TypedField<String> EXT14 = new TypedField<>(String.class, "salesBillMainAndItem.ext14");
                TypedField<String> EXT15 = new TypedField<>(String.class, "salesBillMainAndItem.ext15");
                TypedField<String> EXT16 = new TypedField<>(String.class, "salesBillMainAndItem.ext16");
                TypedField<String> EXT17 = new TypedField<>(String.class, "salesBillMainAndItem.ext17");
                TypedField<String> EXT18 = new TypedField<>(String.class, "salesBillMainAndItem.ext18");
                TypedField<String> EXT19 = new TypedField<>(String.class, "salesBillMainAndItem.ext19");
                TypedField<String> EXT20 = new TypedField<>(String.class, "salesBillMainAndItem.ext20");
                TypedField<String> EXT21 = new TypedField<>(String.class, "salesBillMainAndItem.ext21");
                TypedField<String> EXT22 = new TypedField<>(String.class, "salesBillMainAndItem.ext22");
                TypedField<String> EXT23 = new TypedField<>(String.class, "salesBillMainAndItem.ext23");
                TypedField<String> EXT24 = new TypedField<>(String.class, "salesBillMainAndItem.ext24");
                TypedField<String> EXT25 = new TypedField<>(String.class, "salesBillMainAndItem.ext25");
                TypedField<Long> ID = new TypedField<>(Long.class, "salesBillMainAndItem.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "salesBillMainAndItem.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "salesBillMainAndItem.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "salesBillMainAndItem.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "salesBillMainAndItem.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "salesBillMainAndItem.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "salesBillMainAndItem.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "salesBillMainAndItem.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "salesBillMainAndItem.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "salesBillMainAndItem.delete_flag");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "salesBillMainAndItem.settlementNo");
            }
            interface MATCH_BATCH_AND_SALES_BILL_ITEM {
                static String code () {
                    return "matchBatchAndSalesBillItem" ;
                }
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "matchBatchAndSalesBillItem.batchNo");
                TypedField<String> BOOK_STATUS = new TypedField<>(String.class, "matchBatchAndSalesBillItem.bookStatus");
                TypedField<LocalDateTime> BOOK_TIME = new TypedField<>(LocalDateTime.class, "matchBatchAndSalesBillItem.bookTime");
                TypedField<String> LOCK_STATUS = new TypedField<>(String.class, "matchBatchAndSalesBillItem.lockStatus");
                TypedField<LocalDateTime> LOCK_TIME = new TypedField<>(LocalDateTime.class, "matchBatchAndSalesBillItem.lockTime");
                TypedField<String> SEND_STATUS = new TypedField<>(String.class, "matchBatchAndSalesBillItem.sendStatus");
                TypedField<LocalDateTime> SEND_TIME = new TypedField<>(LocalDateTime.class, "matchBatchAndSalesBillItem.sendTime");
                TypedField<Long> ID = new TypedField<>(Long.class, "matchBatchAndSalesBillItem.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "matchBatchAndSalesBillItem.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "matchBatchAndSalesBillItem.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "matchBatchAndSalesBillItem.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "matchBatchAndSalesBillItem.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "matchBatchAndSalesBillItem.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "matchBatchAndSalesBillItem.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "matchBatchAndSalesBillItem.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "matchBatchAndSalesBillItem.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "matchBatchAndSalesBillItem.delete_flag");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "matchBatchAndSalesBillItem.purchaserNo");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "matchBatchAndSalesBillItem.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "matchBatchAndSalesBillItem.purchaserName");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "matchBatchAndSalesBillItem.sellerNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "matchBatchAndSalesBillItem.sellerTaxNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "matchBatchAndSalesBillItem.sellerName");
                TypedField<String> PUR_GROUP_NO = new TypedField<>(String.class, "matchBatchAndSalesBillItem.purGroupNo");
                TypedField<String> PUR_GROUP_NAME = new TypedField<>(String.class, "matchBatchAndSalesBillItem.purGroupName");
                TypedField<Long> INV_NUM = new TypedField<>(Long.class, "matchBatchAndSalesBillItem.invNum");
                TypedField<Long> SALE_NUM = new TypedField<>(Long.class, "matchBatchAndSalesBillItem.saleNum");
                TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "matchBatchAndSalesBillItem.matchStatus");
                TypedField<String> ANT_STATUS = new TypedField<>(String.class, "matchBatchAndSalesBillItem.antStatus");
                TypedField<String> ACCOUNTING_VOUCHER_NO = new TypedField<>(String.class, "matchBatchAndSalesBillItem.accountingVoucherNo");
                TypedField<String> PRE_VOUCHER_NO = new TypedField<>(String.class, "matchBatchAndSalesBillItem.preVoucherNo");
                TypedField<BigDecimal> SUM_AMOUNT = new TypedField<>(BigDecimal.class, "matchBatchAndSalesBillItem.sumAmount");
                TypedField<String> REMARK = new TypedField<>(String.class, "matchBatchAndSalesBillItem.remark");
                TypedField<BigDecimal> DISCOUNT_AMOUNT = new TypedField<>(BigDecimal.class, "matchBatchAndSalesBillItem.discountAmount");
                TypedField<Long> COLLECTION_CYCLE = new TypedField<>(Long.class, "matchBatchAndSalesBillItem.collectionCycle");
                TypedField<BigDecimal> DISCOUNT_RATE = new TypedField<>(BigDecimal.class, "matchBatchAndSalesBillItem.discountRate");
                TypedField<Boolean> IS_DISCOUNT = new TypedField<>(Boolean.class, "matchBatchAndSalesBillItem.isDiscount");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "matchBatchAndSalesBillItem.paperDrewDate");
                TypedField<String> BOOK_REMARK = new TypedField<>(String.class, "matchBatchAndSalesBillItem.bookRemark");
                TypedField<String> LOCK_REMARK = new TypedField<>(String.class, "matchBatchAndSalesBillItem.lockRemark");
                TypedField<String> INVOICE_NOS = new TypedField<>(String.class, "matchBatchAndSalesBillItem.invoiceNos");
                TypedField<String> PURCHASER_NOS = new TypedField<>(String.class, "matchBatchAndSalesBillItem.purchaserNos");
                TypedField<String> SHIPPING_NOTICES = new TypedField<>(String.class, "matchBatchAndSalesBillItem.shippingNotices");
                TypedField<BigDecimal> MATERIAL_AMOUNT_SUM = new TypedField<>(BigDecimal.class, "matchBatchAndSalesBillItem.materialAmountSum");
                TypedField<BigDecimal> UNPLANNED_DELIVERY_AMOUNT = new TypedField<>(BigDecimal.class, "matchBatchAndSalesBillItem.unplannedDeliveryAmount");
            }
        }
    }
    public interface SalesMaterial {
        static Long id() {
            return 1574646301498085378L;
        }
        static String code() {
            return "salesMaterial";
        }
        TypedField<String> YEAR = new TypedField<>(String.class, "year");
        TypedField<String> MATERIAL_VOUCHER = new TypedField<>(String.class, "materialVoucher");
        TypedField<String> PURCHASE_ORDER = new TypedField<>(String.class, "purchaseOrder");
        TypedField<String> SHIPPING_NOTICE = new TypedField<>(String.class, "shippingNotice");
        TypedField<String> PURCHASING_GROUP_NO = new TypedField<>(String.class, "purchasingGroupNo");
        TypedField<String> SALES_TYPE = new TypedField<>(String.class, "salesType");
        TypedField<String> SALES_BILL_NO = new TypedField<>(String.class, "salesBillNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<String> SUPPLIER_NO = new TypedField<>(String.class, "supplierNo");
        TypedField<String> COMPANY_NO = new TypedField<>(String.class, "companyNo");
        TypedField<String> SALES_TYPE_DESC = new TypedField<>(String.class, "salesTypeDesc");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FlowInstanceLog {
        static Long id() {
            return 1575041142311419906L;
        }
        static String code() {
            return "flowInstanceLog";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INSTANCE_ID = new TypedField<>(String.class, "instanceId");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> SNAPSHOT = new TypedField<>(String.class, "snapshot");
        TypedField<String> SNAPSHOT_FORMAT = new TypedField<>(String.class, "snapshotFormat");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> FLOW_NAME = new TypedField<>(String.class, "flowName");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> START_SNAPSHOT = new TypedField<>(String.class, "startSnapshot");
        TypedField<String> START_SNAPSHOT_FORMAT = new TypedField<>(String.class, "startSnapshotFormat");
        TypedField<String> USER_CONTEXT = new TypedField<>(String.class, "userContext");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FlowReplayLog {
        static Long id() {
            return 1575041143246749697L;
        }
        static String code() {
            return "flowReplayLog";
        }
        TypedField<String> FLOW_INSTANCE_ID = new TypedField<>(String.class, "flowInstanceId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        /**
         * 对一关联关系 关联对象 flowInstanceLog
         */
        TypedField<Long> ONETOMANY_ID = new TypedField<>(Long.class, "onetomany.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONETOMANY {
                static String code () {
                    return "onetomany" ;
                }
                TypedField<Long> ID = new TypedField<>(Long.class, "onetomany.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "onetomany.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "onetomany.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "onetomany.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "onetomany.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "onetomany.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "onetomany.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "onetomany.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "onetomany.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "onetomany.delete_flag");
                TypedField<String> INSTANCE_ID = new TypedField<>(String.class, "onetomany.instanceId");
                TypedField<String> FLOW_CODE = new TypedField<>(String.class, "onetomany.flowCode");
                TypedField<String> ERROR_MSG = new TypedField<>(String.class, "onetomany.errorMsg");
                TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "onetomany.exceptionTrace");
                TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "onetomany.errorNodeId");
                TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "onetomany.rollback");
                TypedField<String> SNAPSHOT = new TypedField<>(String.class, "onetomany.snapshot");
                TypedField<String> SNAPSHOT_FORMAT = new TypedField<>(String.class, "onetomany.snapshotFormat");
                TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "onetomany.rollbackNodeId");
                TypedField<String> FLOW_NAME = new TypedField<>(String.class, "onetomany.flowName");
                TypedField<String> STATUS = new TypedField<>(String.class, "onetomany.status");
                TypedField<String> START_SNAPSHOT = new TypedField<>(String.class, "onetomany.startSnapshot");
                TypedField<String> START_SNAPSHOT_FORMAT = new TypedField<>(String.class, "onetomany.startSnapshotFormat");
                TypedField<String> USER_CONTEXT = new TypedField<>(String.class, "onetomany.userContext");
            }
        }
    }
    public interface SalesMaterialItemInit {
        static Long id() {
            return 1585524284434079746L;
        }
        static String code() {
            return "salesMaterialItemInit";
        }
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> MATERIAL_VOUCHER_LINE_ITEM = new TypedField<>(String.class, "materialVoucherLineItem");
        TypedField<String> YEAR = new TypedField<>(String.class, "year");
        TypedField<String> MATERIAL_VOUCHER = new TypedField<>(String.class, "materialVoucher");
        TypedField<String> LINE_ITEM = new TypedField<>(String.class, "lineItem");
        TypedField<String> PURCHASE_ORDER = new TypedField<>(String.class, "purchaseOrder");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantityUnit");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> MATERIAL = new TypedField<>(String.class, "material");
        TypedField<String> SHIPPING_NOTICE = new TypedField<>(String.class, "shippingNotice");
        TypedField<String> INBOUND_DELIVERY = new TypedField<>(String.class, "inboundDelivery");
        TypedField<String> ORDER_LINE_ITEM = new TypedField<>(String.class, "orderLineItem");
        TypedField<String> PURCHASING_GROUP_NO = new TypedField<>(String.class, "purchasingGroupNo");
        TypedField<String> FLOW_STATUS = new TypedField<>(String.class, "flowStatus");
        TypedField<String> SALES_TYPE = new TypedField<>(String.class, "salesType");
        TypedField<String> SALES_BILL_NO = new TypedField<>(String.class, "salesBillNo");
        TypedField<String> ABSENT_MESSAGE = new TypedField<>(String.class, "absentMessage");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<BigDecimal> NET_PRICE = new TypedField<>(BigDecimal.class, "netPrice");
        TypedField<String> SERVICE_ENTRY = new TypedField<>(String.class, "serviceEntry");
        TypedField<String> MATERIAL_DESCRIBE = new TypedField<>(String.class, "materialDescribe");
        TypedField<String> MATERIAL_NO = new TypedField<>(String.class, "materialNo");
        TypedField<String> SUPPLIER_NO = new TypedField<>(String.class, "supplierNo");
        TypedField<String> COMPANY_NO = new TypedField<>(String.class, "companyNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
}
