package com.xforceplus.ultraman.app.jcsmec.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcsmec.entity.InvPriorityConfig;
import com.xforceplus.ultraman.app.jcsmec.service.IInvPriorityConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-28
 */
@RestController
public class InvPriorityConfigController {

  @Autowired
  private IInvPriorityConfigService invPriorityConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invPriorityConfig ${table.comment}
   * @return
   */
  @GetMapping("/invpriorityconfigs" )
  public XfR getInvPriorityConfigs(XfPage page, InvPriorityConfig invPriorityConfig) {
    return XfR.ok(invPriorityConfigServiceImpl.page(page, Wrappers.query(invPriorityConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invpriorityconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invPriorityConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invPriorityConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/invpriorityconfigs")
  public XfR save(@RequestBody InvPriorityConfig invPriorityConfig) {
     return XfR.ok(invPriorityConfigServiceImpl.save(invPriorityConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invPriorityConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/invpriorityconfigs/{id}")
  public XfR putUpdate(@RequestBody InvPriorityConfig invPriorityConfig,@PathVariable Long id) {
      invPriorityConfig.setId(id);
      return XfR.ok(invPriorityConfigServiceImpl.updateById(invPriorityConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invPriorityConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invpriorityconfigs/{id}")
  public XfR patchUpdate(@RequestBody InvPriorityConfig invPriorityConfig,@PathVariable Long id) {
      InvPriorityConfig upinvPriorityConfig = invPriorityConfigServiceImpl.getById(id);
      if(upinvPriorityConfig != null){
        upinvPriorityConfig = ObjectCopyUtils.copyProperties(invPriorityConfig,upinvPriorityConfig,true);
      }
      return XfR.ok(invPriorityConfigServiceImpl.updateById(upinvPriorityConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invpriorityconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invPriorityConfigServiceImpl.removeById(id));
  }

  @PostMapping("/invpriorityconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inv_priority_config");
     params.put("request", condition);

     return XfR.ok(invPriorityConfigServiceImpl.querys(params));
  }

}
