package com.xforceplus.ultraman.app.jcsmec.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcsmec.entity.SalesMaterial;
import com.xforceplus.ultraman.app.jcsmec.service.ISalesMaterialService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-28
 */
@RestController
public class SalesMaterialController {

  @Autowired
  private ISalesMaterialService salesMaterialServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesMaterial ${table.comment}
   * @return
   */
  @GetMapping("/salesmaterials" )
  public XfR getSalesMaterials(XfPage page, SalesMaterial salesMaterial) {
    return XfR.ok(salesMaterialServiceImpl.page(page, Wrappers.query(salesMaterial)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesmaterials/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesMaterialServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesMaterial ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesmaterials")
  public XfR save(@RequestBody SalesMaterial salesMaterial) {
     return XfR.ok(salesMaterialServiceImpl.save(salesMaterial));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesMaterial ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesmaterials/{id}")
  public XfR putUpdate(@RequestBody SalesMaterial salesMaterial,@PathVariable Long id) {
      salesMaterial.setId(id);
      return XfR.ok(salesMaterialServiceImpl.updateById(salesMaterial));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesMaterial ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesmaterials/{id}")
  public XfR patchUpdate(@RequestBody SalesMaterial salesMaterial,@PathVariable Long id) {
      SalesMaterial upsalesMaterial = salesMaterialServiceImpl.getById(id);
      if(upsalesMaterial != null){
        upsalesMaterial = ObjectCopyUtils.copyProperties(salesMaterial,upsalesMaterial,true);
      }
      return XfR.ok(salesMaterialServiceImpl.updateById(upsalesMaterial));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesmaterials/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesMaterialServiceImpl.removeById(id));
  }

  @PostMapping("/salesmaterials/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_material");
     params.put("request", condition);

     return XfR.ok(salesMaterialServiceImpl.querys(params));
  }

}
