package com.xforceplus.ultraman.app.jcsmec.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcsmec.entity.SalesMaterialItem;
import com.xforceplus.ultraman.app.jcsmec.service.ISalesMaterialItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-28
 */
@RestController
public class SalesMaterialItemController {

  @Autowired
  private ISalesMaterialItemService salesMaterialItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesMaterialItem ${table.comment}
   * @return
   */
  @GetMapping("/salesmaterialitems" )
  public XfR getSalesMaterialItems(XfPage page, SalesMaterialItem salesMaterialItem) {
    return XfR.ok(salesMaterialItemServiceImpl.page(page, Wrappers.query(salesMaterialItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesmaterialitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesMaterialItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesMaterialItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesmaterialitems")
  public XfR save(@RequestBody SalesMaterialItem salesMaterialItem) {
     return XfR.ok(salesMaterialItemServiceImpl.save(salesMaterialItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesMaterialItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesmaterialitems/{id}")
  public XfR putUpdate(@RequestBody SalesMaterialItem salesMaterialItem,@PathVariable Long id) {
      salesMaterialItem.setId(id);
      return XfR.ok(salesMaterialItemServiceImpl.updateById(salesMaterialItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesMaterialItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesmaterialitems/{id}")
  public XfR patchUpdate(@RequestBody SalesMaterialItem salesMaterialItem,@PathVariable Long id) {
      SalesMaterialItem upsalesMaterialItem = salesMaterialItemServiceImpl.getById(id);
      if(upsalesMaterialItem != null){
        upsalesMaterialItem = ObjectCopyUtils.copyProperties(salesMaterialItem,upsalesMaterialItem,true);
      }
      return XfR.ok(salesMaterialItemServiceImpl.updateById(upsalesMaterialItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesmaterialitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesMaterialItemServiceImpl.removeById(id));
  }

  @PostMapping("/salesmaterialitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_material_item");
     params.put("request", condition);

     return XfR.ok(salesMaterialItemServiceImpl.querys(params));
  }

}
