package com.xforceplus.ultraman.app.jcsmec.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcsmec.entity.MatchBatch;
import com.xforceplus.ultraman.app.jcsmec.service.IMatchBatchService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-10-13
 */
@RestController
public class MatchBatchController {

  @Autowired
  private IMatchBatchService matchBatchServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param matchBatch ${table.comment}
   * @return
   */
  @GetMapping("/matchbatchs" )
  public XfR getMatchBatchs(XfPage page, MatchBatch matchBatch) {
    return XfR.ok(matchBatchServiceImpl.page(page, Wrappers.query(matchBatch)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/matchbatchs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(matchBatchServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param matchBatch ${table.comment}
   * @return XfR
   */
  @PostMapping("/matchbatchs")
  public XfR save(@RequestBody MatchBatch matchBatch) {
     return XfR.ok(matchBatchServiceImpl.save(matchBatch));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param matchBatch ${table.comment}
   * @return XfR
   */
  @PutMapping("/matchbatchs/{id}")
  public XfR putUpdate(@RequestBody MatchBatch matchBatch,@PathVariable Long id) {
      matchBatch.setId(id);
      return XfR.ok(matchBatchServiceImpl.updateById(matchBatch));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param matchBatch ${table.comment}
   * @return XfR
   */
  @PatchMapping("/matchbatchs/{id}")
  public XfR patchUpdate(@RequestBody MatchBatch matchBatch,@PathVariable Long id) {
      MatchBatch upmatchBatch = matchBatchServiceImpl.getById(id);
      if(upmatchBatch != null){
        upmatchBatch = ObjectCopyUtils.copyProperties(matchBatch,upmatchBatch,true);
      }
      return XfR.ok(matchBatchServiceImpl.updateById(upmatchBatch));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/matchbatchs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(matchBatchServiceImpl.removeById(id));
  }

  @PostMapping("/matchbatchs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "match_batch");
     params.put("request", condition);

     return XfR.ok(matchBatchServiceImpl.querys(params));
  }

}
