package com.xforceplus.ultraman.app.jcsmec.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcsmec.entity.SalesMaterialItemInit;
import com.xforceplus.ultraman.app.jcsmec.service.ISalesMaterialItemInitService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-10-13
 */
@RestController
public class SalesMaterialItemInitController {

  @Autowired
  private ISalesMaterialItemInitService salesMaterialItemInitServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesMaterialItemInit ${table.comment}
   * @return
   */
  @GetMapping("/salesmaterialiteminits" )
  public XfR getSalesMaterialItemInits(XfPage page, SalesMaterialItemInit salesMaterialItemInit) {
    return XfR.ok(salesMaterialItemInitServiceImpl.page(page, Wrappers.query(salesMaterialItemInit)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesmaterialiteminits/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesMaterialItemInitServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesMaterialItemInit ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesmaterialiteminits")
  public XfR save(@RequestBody SalesMaterialItemInit salesMaterialItemInit) {
     return XfR.ok(salesMaterialItemInitServiceImpl.save(salesMaterialItemInit));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesMaterialItemInit ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesmaterialiteminits/{id}")
  public XfR putUpdate(@RequestBody SalesMaterialItemInit salesMaterialItemInit,@PathVariable Long id) {
      salesMaterialItemInit.setId(id);
      return XfR.ok(salesMaterialItemInitServiceImpl.updateById(salesMaterialItemInit));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesMaterialItemInit ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesmaterialiteminits/{id}")
  public XfR patchUpdate(@RequestBody SalesMaterialItemInit salesMaterialItemInit,@PathVariable Long id) {
      SalesMaterialItemInit upsalesMaterialItemInit = salesMaterialItemInitServiceImpl.getById(id);
      if(upsalesMaterialItemInit != null){
        upsalesMaterialItemInit = ObjectCopyUtils.copyProperties(salesMaterialItemInit,upsalesMaterialItemInit,true);
      }
      return XfR.ok(salesMaterialItemInitServiceImpl.updateById(upsalesMaterialItemInit));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesmaterialiteminits/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesMaterialItemInitServiceImpl.removeById(id));
  }

  @PostMapping("/salesmaterialiteminits/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_material_item_init");
     params.put("request", condition);

     return XfR.ok(salesMaterialItemInitServiceImpl.querys(params));
  }

}
