package com.xforceplus.ultraman.app.jcsmjt.controller;


/**
 * 请款单表feign客户端
 *
 * @author ultraman
 * @date 2021-12-02
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcsmjt.entity.PrepareBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-smjt")
public interface PrepareBillFeignApi {

  /**
   * 通过id查询请款单表
   * @param  id
   * @return R
   */
  @GetMapping("/prepareBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增请款单表
   * @param prepareBill 请款单表
   * @return R
   */
  @PostMapping("/prepareBill/add")
  public R save(@RequestBody PrepareBill prepareBill);

  /**
   * 修改请款单表
   * @param prepareBill 请款单表
   * @return R
   */
  @PostMapping("/prepareBill/update")
  public R updateById(@RequestBody PrepareBill prepareBill);

  /**
   * 通过id删除请款单表
   * @param  id
   * @return R
   */
  @DeleteMapping("/prepareBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}