package com.xforceplus.ultraman.app.jcsmjt.controller;


/**
 * 合同单据表feign客户端
 *
 * @author ultraman
 * @date 2021-12-21
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcsmjt.entity.ContractBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-smjt")
public interface ContractBillFeignApi {

  /**
   * 通过id查询合同单据表
   * @param  id
   * @return R
   */
  @GetMapping("/contractBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增合同单据表
   * @param contractBill 合同单据表
   * @return R
   */
  @PostMapping("/contractBill/add")
  public R save(@RequestBody ContractBill contractBill);

  /**
   * 修改合同单据表
   * @param contractBill 合同单据表
   * @return R
   */
  @PostMapping("/contractBill/update")
  public R updateById(@RequestBody ContractBill contractBill);

  /**
   * 通过id删除合同单据表
   * @param  id
   * @return R
   */
  @DeleteMapping("/contractBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}