package com.xforceplus.ultraman.app.jcsmjt.controller;


/**
 * 合同税率表feign客户端
 *
 * @author ultraman
 * @date 2021-12-21
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcsmjt.entity.ContractTaxRate;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-smjt")
public interface ContractTaxRateFeignApi {

  /**
   * 通过id查询合同税率表
   * @param  id
   * @return R
   */
  @GetMapping("/contractTaxRate/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增合同税率表
   * @param contractTaxRate 合同税率表
   * @return R
   */
  @PostMapping("/contractTaxRate/add")
  public R save(@RequestBody ContractTaxRate contractTaxRate);

  /**
   * 修改合同税率表
   * @param contractTaxRate 合同税率表
   * @return R
   */
  @PostMapping("/contractTaxRate/update")
  public R updateById(@RequestBody ContractTaxRate contractTaxRate);

  /**
   * 通过id删除合同税率表
   * @param  id
   * @return R
   */
  @DeleteMapping("/contractTaxRate/del/{id}" )
  public R removeById(@PathVariable Long id);

}