package com.xforceplus.ultraman.app.jcsmjt.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 合同类型
 * </p>
 *
 * @author ultraman
 * @since 2021-12-21
 */
public enum ContractType {

    _801001("801001", "市场调查咨询合同"),
    _801002("801002", "可行性研究咨询合同"),
    _801003("801003", "环境评估咨询合同"),
    _801004("801004", "能源评估咨询合同"),
    _801005("801005", "土地评估咨询合同"),
    _801006("801006", "资产评估咨询合同"),
    _801007("801007", "公司注册与咨询合同"),
    _801008("801008", "其它拓展咨询合同"),
    _802001("802001", "勘察及基坑支护合同（工程用）"),
    _802002("802002", "建筑方案设计合同"),
    _802003("802003", "境外设计合同"),
    _802004("802004", "景观园林方案及施工图设计合同"),
    _802005("802005", "室内方案及施工图设计合同"),
    _802006("802006", "专项设计合同"),
    _802007("802007", "专业/顾问服务合同"),
    _802008("802008", "其他设计合同"),
    _802009("802009", "战略合作设计合同"),
    _802010("802010", "景观园林方案设计合同"),
    _802011("802011", "景观园林扩初及施工图设计合同"),
    _802012("802012", "建筑方案及施工图设计合同"),
    _802013("802013", "建筑扩初及施工图设计合同"),
    _802014("802014", "室内方案设计合同"),
    _802015("802015", "室内扩初及施工图设计合同"),
    _802016("802016", "规划设计/建筑概念设计合同"),
    _803001("803001", "规划报建合同"),
    _803002("803002", "施工报建合同"),
    _803003("803003", "销售许可证类合同"),
    _803004("803004", "增容合同"),
    _803005("803005", "公用事业工程专业设计合同"),
    _803006("803006", "公用事业工程施工监督检测合同"),
    _803007("803007", "其他报建合同"),
    _8040("8040", "基础设施配套合同"),
    _805001("805001", "教育配套工程合同"),
    _805002("805002", "医疗配套工程合同"),
    _805003("805003", "生活配套工程合同"),
    _805004("805004", "其他公建配套合同"),
    _806001("806001", "土地面积测绘合同(规划防线测绘)"),
    _806002("806002", "销售面积前置测绘合同(预售面积测绘合同)"),
    _806003("806003", "销售面积测绘合同"),
    _806004("806004", "竣工面积测绘合同"),
    _806005("806005", "其他测绘合同"),
    _807001("807001", "工程保险合同"),
    _807002("807002", "建设监理合同"),
    _807003("807003", "造价咨询合同"),
    _807004("807004", "其他成本类工程咨询合同"),
    _808001("808001", "试验检测合同"),
    _808002("808002", "工程专项技术咨询合同"),
    _808003("808003", "其他开发类工程咨询合同"),
    _809001("809001", "物业合同"),
    _809002("809002", "物业维修合同"),
    _809003("809003", "其他物业维保合同"),
    _809004("809004", "其他物业服务合同（客服专用-开办费）"),
    _809005("809005", "其他物业服务合同（营销专用）"),
    _809006("809006", "其他物业服务合同（客服专用-前介费）"),
    _809007("809007", "其他物业服务合同（客户关怀基金）"),
    _901001("901001", "基坑土石方工程合同"),
    _901002("901002", "基坑支护工程合同"),
    _901003("901003", "土建主承包合同"),
    _901004("901004", "地基处理工程"),
    _901005("901005", "钢结构合同"),
    _901006("901006", "PC合同"),
    _901007("901007", "防水工程"),
    _902001("902001", "临时水电工程合同"),
    _902002("902002", "场地整理工程合同"),
    _9030("9030", "基础工程合同"),
    _904001("904001", "人防门工程合同"),
    _904002("904002", "防火门工程合同"),
    _904003("904003", "进户门工程合同"),
    _905001("905001", "综合机电工程合同"),
    _905002("905002", "消防工程合同"),
    _905003("905003", "弱电工程合同"),
    _905004("905004", "电梯工程合同"),
    _905005("905005", "泛光照明工程合同"),
    _905006("905006", "地暖工程合同"),
    _906001("906001", "外立面门窗工程合同"),
    _906002("906002", "外立面保温涂料合同"),
    _906003("906003", "栏杆工程合同"),
    _906004("906004", "外立面幕墙工程合同"),
    _906005("906005", "外立面装饰工程合同-其他"),
    _907001("907001", "公共部位装饰工程合同"),
    _907002("907002", "室内精装工程合同"),
    _908001("908001", "交通设施及划线工程合同"),
    _908002("908002", "园林景观工程合同"),
    _908003("908003", "小区道路及排水工程合同"),
    _908004("908004", "标识及门牌工程合同"),
    _9090("9090", "其他工程合同"),
    _90A001("90A001", "室外给排水工程合同"),
    _90A002("90A002", "室外供电工程合同"),
    _90A003("90A003", "燃气工程合同"),
    _90A004("90A004", "供热工程合同"),
    _90A005("90A005", "有线电视工程合同"),
    _90A006("90A006", "电信工程合同"),
    _90A007("90A007", "其他建安类开发工程合同"),
    _90A008("90A008", "物业在管项目工程维修合同"),
    _90B001("90B001", "酒店专项采购合同"),
    _90B002("90B002", "其他自持物业专项采购合同"),
    _90B003("90B003", "主题乐园专项采购合同（设计）"),
    _90B004("90B004", "商管自持商业专项采购合同"),
    _90B005("90B005", "商管写字楼专项采购合同"),
    _90B006("90B006", "文化公司专项采购合同"),
    _90B007("90B007", "主题乐园专项采购合同（工程）"),
    _90B008("90B008", "主题乐园专项采购合同（经营）"),
    _90B009("90B009", "主题乐园专项采购合同（设备）"),
    _90B010("90B010", "主题乐园专项采购合同（演艺）"),
    A01001("A01001", "售楼处室内设计合同"),
    A01002("A01002", "售楼处建设费"),
    A01003("A01003", "售楼处精装修合同"),
    A01004("A01004", "软装采购安装合同"),
    A01005("A01005", "其他合同"),
    A02001("A02001", "展示区园林设计合同"),
    A02002("A02002", "展示区景观工程合同"),
    A02003("A02003", "其他合同"),
    A03001("A03001", "样板房室内设计合同"),
    A03002("A03002", "样板房建设费"),
    A03003("A03003", "样板房精装修合同"),
    A03004("A03004", "软装采购安装合同"),
    A03005("A03005", "其他合同"),
    A04001("A04001", "展示区建筑设计合同"),
    C001("C001", "建安成本费用"),
    C002("C002", "报建、测绘费用"),
    C003("C003", "土地费用"),
    C004("C004", "前期拓展咨询费用"),
    C005("C005", "售楼处、样板房物品购买"),
    C006("C006", "物业类费用"),
    C007("C007", "开发及市政配套费用非合同付款"),
    C008("C008", "勘察设计非合同付款"),
    C009("C009", "工程专项技术咨询非合同付款"),
    C010("C010", "商管招商推广旺场费非合同付款"),
    C011("C011", "客服非合同付款"),
    C012("C012", "销售返租费用"),
    C013("C013", "空置房费用"),
    C014("C014", "物业补亏费用"),
    C015("C015", "维保人员费用"),
    C016("C016", "世茂币费用（2018前）"),
    C017("C017", "合作方-营销费"),
    C018("C018", "合作方-品牌费"),
    C019("C019", "合作方-管理费"),
    C020("C020", "世茂方-管理费"),
    C02101("C02101", "建委招投标现场监督、公证服务(一级用）-停用"),
    C02102("C02102", "拆迁专项资金(一级用）-停用"),
    C02103("C02103", "委托入市交易费(一级用）-停用"),
    C02104("C02104", "项目改造方案审批费(一级用）-停用"),
    C02105("C02105", "项目专规审批费(一级用）-停用"),
    C02106("C02106", "项目地形图购买费(一级用）-停用"),
    C02107("C02107", "晒图费(一级用）-停用"),
    C02108("C02108", "土地征用费非合同付款(一级用）-停用"),
    C02109("C02109", "间接费用非合同付款(一级用）"),
    C022("C022", "空置房费用（提前回款物业费专项）空置房费用（提前回款物业费专项）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ContractType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ContractType fromCode(String code){
        switch(code) {
            case "801001":
                return _801001;
            case "801002":
                return _801002;
            case "801003":
                return _801003;
            case "801004":
                return _801004;
            case "801005":
                return _801005;
            case "801006":
                return _801006;
            case "801007":
                return _801007;
            case "801008":
                return _801008;
            case "802001":
                return _802001;
            case "802002":
                return _802002;
            case "802003":
                return _802003;
            case "802004":
                return _802004;
            case "802005":
                return _802005;
            case "802006":
                return _802006;
            case "802007":
                return _802007;
            case "802008":
                return _802008;
            case "802009":
                return _802009;
            case "802010":
                return _802010;
            case "802011":
                return _802011;
            case "802012":
                return _802012;
            case "802013":
                return _802013;
            case "802014":
                return _802014;
            case "802015":
                return _802015;
            case "802016":
                return _802016;
            case "803001":
                return _803001;
            case "803002":
                return _803002;
            case "803003":
                return _803003;
            case "803004":
                return _803004;
            case "803005":
                return _803005;
            case "803006":
                return _803006;
            case "803007":
                return _803007;
            case "8040":
                return _8040;
            case "805001":
                return _805001;
            case "805002":
                return _805002;
            case "805003":
                return _805003;
            case "805004":
                return _805004;
            case "806001":
                return _806001;
            case "806002":
                return _806002;
            case "806003":
                return _806003;
            case "806004":
                return _806004;
            case "806005":
                return _806005;
            case "807001":
                return _807001;
            case "807002":
                return _807002;
            case "807003":
                return _807003;
            case "807004":
                return _807004;
            case "808001":
                return _808001;
            case "808002":
                return _808002;
            case "808003":
                return _808003;
            case "809001":
                return _809001;
            case "809002":
                return _809002;
            case "809003":
                return _809003;
            case "809004":
                return _809004;
            case "809005":
                return _809005;
            case "809006":
                return _809006;
            case "809007":
                return _809007;
            case "901001":
                return _901001;
            case "901002":
                return _901002;
            case "901003":
                return _901003;
            case "901004":
                return _901004;
            case "901005":
                return _901005;
            case "901006":
                return _901006;
            case "901007":
                return _901007;
            case "902001":
                return _902001;
            case "902002":
                return _902002;
            case "9030":
                return _9030;
            case "904001":
                return _904001;
            case "904002":
                return _904002;
            case "904003":
                return _904003;
            case "905001":
                return _905001;
            case "905002":
                return _905002;
            case "905003":
                return _905003;
            case "905004":
                return _905004;
            case "905005":
                return _905005;
            case "905006":
                return _905006;
            case "906001":
                return _906001;
            case "906002":
                return _906002;
            case "906003":
                return _906003;
            case "906004":
                return _906004;
            case "906005":
                return _906005;
            case "907001":
                return _907001;
            case "907002":
                return _907002;
            case "908001":
                return _908001;
            case "908002":
                return _908002;
            case "908003":
                return _908003;
            case "908004":
                return _908004;
            case "9090":
                return _9090;
            case "90A001":
                return _90A001;
            case "90A002":
                return _90A002;
            case "90A003":
                return _90A003;
            case "90A004":
                return _90A004;
            case "90A005":
                return _90A005;
            case "90A006":
                return _90A006;
            case "90A007":
                return _90A007;
            case "90A008":
                return _90A008;
            case "90B001":
                return _90B001;
            case "90B002":
                return _90B002;
            case "90B003":
                return _90B003;
            case "90B004":
                return _90B004;
            case "90B005":
                return _90B005;
            case "90B006":
                return _90B006;
            case "90B007":
                return _90B007;
            case "90B008":
                return _90B008;
            case "90B009":
                return _90B009;
            case "90B010":
                return _90B010;
            case "A01001":
                return A01001;
            case "A01002":
                return A01002;
            case "A01003":
                return A01003;
            case "A01004":
                return A01004;
            case "A01005":
                return A01005;
            case "A02001":
                return A02001;
            case "A02002":
                return A02002;
            case "A02003":
                return A02003;
            case "A03001":
                return A03001;
            case "A03002":
                return A03002;
            case "A03003":
                return A03003;
            case "A03004":
                return A03004;
            case "A03005":
                return A03005;
            case "A04001":
                return A04001;
            case "C001":
                return C001;
            case "C002":
                return C002;
            case "C003":
                return C003;
            case "C004":
                return C004;
            case "C005":
                return C005;
            case "C006":
                return C006;
            case "C007":
                return C007;
            case "C008":
                return C008;
            case "C009":
                return C009;
            case "C010":
                return C010;
            case "C011":
                return C011;
            case "C012":
                return C012;
            case "C013":
                return C013;
            case "C014":
                return C014;
            case "C015":
                return C015;
            case "C016":
                return C016;
            case "C017":
                return C017;
            case "C018":
                return C018;
            case "C019":
                return C019;
            case "C020":
                return C020;
            case "C02101":
                return C02101;
            case "C02102":
                return C02102;
            case "C02103":
                return C02103;
            case "C02104":
                return C02104;
            case "C02105":
                return C02105;
            case "C02106":
                return C02106;
            case "C02107":
                return C02107;
            case "C02108":
                return C02108;
            case "C02109":
                return C02109;
            case "C022":
                return C022;
            default:
                return null;
        }
    }
}
