package com.xforceplus.ultraman.app.jcsmjt.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcsmjt.entity.PrepareBill;
import com.xforceplus.ultraman.app.jcsmjt.service.IPrepareBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 请款单表前端控制器
 *
 * @author ultraman
 * @date 2021-12-21
 */
@RestController
public class PrepareBillController {

  @Autowired
  private IPrepareBillService prepareBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param prepareBill 请款单表
   * @return
   */
  @GetMapping("/preparebills" )
  public XfR getPrepareBills(XfPage page, PrepareBill prepareBill) {
    return XfR.ok(prepareBillServiceImpl.page(page, Wrappers.query(prepareBill)));
  }

  /**
   * 通过id查询请款单表
   * @param  id
   * @return XfR
   */
  @GetMapping("/preparebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(prepareBillServiceImpl.getById(id));
  }

  /**
   * 新增请款单表
   * @param prepareBill 请款单表
   * @return XfR
   */
  @PostMapping("/preparebills")
  public XfR save(@RequestBody PrepareBill prepareBill) {
     return XfR.ok(prepareBillServiceImpl.save(prepareBill));
  }

  /**
   * 修改-传入修改后的全部数据请款单表
   * @param prepareBill 请款单表
   * @return XfR
   */
  @PutMapping("/preparebills/{id}")
  public XfR putUpdate(@RequestBody PrepareBill prepareBill,@PathVariable Long id) {
      prepareBill.setId(id);
      return XfR.ok(prepareBillServiceImpl.updateById(prepareBill));
  }

  /**
   * 修改-传入修改的数据请款单表
   * @param prepareBill 请款单表
   * @return XfR
   */
  @PatchMapping("/preparebills/{id}")
  public XfR patchUpdate(@RequestBody PrepareBill prepareBill,@PathVariable Long id) {
      PrepareBill upprepareBill = prepareBillServiceImpl.getById(id);
      if(upprepareBill != null){
        upprepareBill = ObjectCopyUtils.copyProperties(prepareBill,upprepareBill,true);
      }
      return XfR.ok(prepareBillServiceImpl.updateById(upprepareBill));
  }

  /**
   * 通过id删除请款单表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/preparebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(prepareBillServiceImpl.removeById(id));
  }

  @PostMapping("/preparebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "prepare_bill");
     params.put("request", condition);

     return XfR.ok(prepareBillServiceImpl.querys(params));
  }

}
