package com.xforceplus.ultraman.app.jcsmjt.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcsmjt.entity.PurchaserInvoiceMain;
import com.xforceplus.ultraman.app.jcsmjt.service.IPurchaserInvoiceMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 进项发票主表前端控制器
 *
 * @author ultraman
 * @date 2021-12-21
 */
@RestController
public class PurchaserInvoiceMainController {

  @Autowired
  private IPurchaserInvoiceMainService purchaserInvoiceMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param purchaserInvoiceMain 进项发票主表
   * @return
   */
  @GetMapping("/purchaserinvoicemains" )
  public XfR getPurchaserInvoiceMains(XfPage page, PurchaserInvoiceMain purchaserInvoiceMain) {
    return XfR.ok(purchaserInvoiceMainServiceImpl.page(page, Wrappers.query(purchaserInvoiceMain)));
  }

  /**
   * 通过id查询进项发票主表
   * @param  id
   * @return XfR
   */
  @GetMapping("/purchaserinvoicemains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(purchaserInvoiceMainServiceImpl.getById(id));
  }

  /**
   * 新增进项发票主表
   * @param purchaserInvoiceMain 进项发票主表
   * @return XfR
   */
  @PostMapping("/purchaserinvoicemains")
  public XfR save(@RequestBody PurchaserInvoiceMain purchaserInvoiceMain) {
     return XfR.ok(purchaserInvoiceMainServiceImpl.save(purchaserInvoiceMain));
  }

  /**
   * 修改-传入修改后的全部数据进项发票主表
   * @param purchaserInvoiceMain 进项发票主表
   * @return XfR
   */
  @PutMapping("/purchaserinvoicemains/{id}")
  public XfR putUpdate(@RequestBody PurchaserInvoiceMain purchaserInvoiceMain,@PathVariable Long id) {
      purchaserInvoiceMain.setId(id);
      return XfR.ok(purchaserInvoiceMainServiceImpl.updateById(purchaserInvoiceMain));
  }

  /**
   * 修改-传入修改的数据进项发票主表
   * @param purchaserInvoiceMain 进项发票主表
   * @return XfR
   */
  @PatchMapping("/purchaserinvoicemains/{id}")
  public XfR patchUpdate(@RequestBody PurchaserInvoiceMain purchaserInvoiceMain,@PathVariable Long id) {
      PurchaserInvoiceMain uppurchaserInvoiceMain = purchaserInvoiceMainServiceImpl.getById(id);
      if(uppurchaserInvoiceMain != null){
        uppurchaserInvoiceMain = ObjectCopyUtils.copyProperties(purchaserInvoiceMain,uppurchaserInvoiceMain,true);
      }
      return XfR.ok(purchaserInvoiceMainServiceImpl.updateById(uppurchaserInvoiceMain));
  }

  /**
   * 通过id删除进项发票主表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/purchaserinvoicemains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(purchaserInvoiceMainServiceImpl.removeById(id));
  }

  @PostMapping("/purchaserinvoicemains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "purchaser_invoice_main");
     params.put("request", condition);

     return XfR.ok(purchaserInvoiceMainServiceImpl.querys(params));
  }

}
