package com.xforceplus.ultraman.app.jcsongxia.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcsongxia.entity.BizOrderTypeInfo;
import com.xforceplus.ultraman.app.jcsongxia.service.IBizOrderTypeInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-24
 */
@RestController
public class BizOrderTypeInfoController {

  @Autowired
  private IBizOrderTypeInfoService bizOrderTypeInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOrderTypeInfo ${table.comment}
   * @return
   */
  @GetMapping("/bizordertypeinfos" )
  public XfR getBizOrderTypeInfos(XfPage page, BizOrderTypeInfo bizOrderTypeInfo) {
    return XfR.ok(bizOrderTypeInfoServiceImpl.page(page, Wrappers.query(bizOrderTypeInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizordertypeinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOrderTypeInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bizOrderTypeInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/bizordertypeinfos")
  public XfR save(@RequestBody BizOrderTypeInfo bizOrderTypeInfo) {
     return XfR.ok(bizOrderTypeInfoServiceImpl.save(bizOrderTypeInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bizOrderTypeInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/bizordertypeinfos/{id}")
  public XfR putUpdate(@RequestBody BizOrderTypeInfo bizOrderTypeInfo,@PathVariable Long id) {
      bizOrderTypeInfo.setId(id);
      return XfR.ok(bizOrderTypeInfoServiceImpl.updateById(bizOrderTypeInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bizOrderTypeInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bizordertypeinfos/{id}")
  public XfR patchUpdate(@RequestBody BizOrderTypeInfo bizOrderTypeInfo,@PathVariable Long id) {
      BizOrderTypeInfo upbizOrderTypeInfo = bizOrderTypeInfoServiceImpl.getById(id);
      if(upbizOrderTypeInfo != null){
        upbizOrderTypeInfo = ObjectCopyUtils.copyProperties(bizOrderTypeInfo,upbizOrderTypeInfo,true);
      }
      return XfR.ok(bizOrderTypeInfoServiceImpl.updateById(upbizOrderTypeInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizordertypeinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOrderTypeInfoServiceImpl.removeById(id));
  }

  @PostMapping("/bizordertypeinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_order_type_info");
     params.put("request", condition);

     return XfR.ok(bizOrderTypeInfoServiceImpl.querys(params));
  }

}
