package com.xforceplus.ultraman.app.jcsongxia.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcsongxia.entity.OrgGoods;
import com.xforceplus.ultraman.app.jcsongxia.service.IOrgGoodsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-24
 */
@RestController
public class OrgGoodsController {

  @Autowired
  private IOrgGoodsService orgGoodsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orgGoods ${table.comment}
   * @return
   */
  @GetMapping("/orggoodss" )
  public XfR getOrgGoodss(XfPage page, OrgGoods orgGoods) {
    return XfR.ok(orgGoodsServiceImpl.page(page, Wrappers.query(orgGoods)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orggoodss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orgGoodsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orgGoods ${table.comment}
   * @return XfR
   */
  @PostMapping("/orggoodss")
  public XfR save(@RequestBody OrgGoods orgGoods) {
     return XfR.ok(orgGoodsServiceImpl.save(orgGoods));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orgGoods ${table.comment}
   * @return XfR
   */
  @PutMapping("/orggoodss/{id}")
  public XfR putUpdate(@RequestBody OrgGoods orgGoods,@PathVariable Long id) {
      orgGoods.setId(id);
      return XfR.ok(orgGoodsServiceImpl.updateById(orgGoods));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orgGoods ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orggoodss/{id}")
  public XfR patchUpdate(@RequestBody OrgGoods orgGoods,@PathVariable Long id) {
      OrgGoods uporgGoods = orgGoodsServiceImpl.getById(id);
      if(uporgGoods != null){
        uporgGoods = ObjectCopyUtils.copyProperties(orgGoods,uporgGoods,true);
      }
      return XfR.ok(orgGoodsServiceImpl.updateById(uporgGoods));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orggoodss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orgGoodsServiceImpl.removeById(id));
  }

  @PostMapping("/orggoodss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "org_goods");
     params.put("request", condition);

     return XfR.ok(orgGoodsServiceImpl.querys(params));
  }

}
