package com.xforceplus.ultraman.app.jcsunart.controller;


/**
 * 发票退票推送记录feign客户端
 *
 * @author ultraman
 * @date 2022-08-04
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcsunart.entity.InvoiceRefundRecord;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-sunart")
public interface InvoiceRefundRecordFeignApi {

  /**
   * 通过id查询发票退票推送记录
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceRefundRecord/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票退票推送记录
   * @param invoiceRefundRecord 发票退票推送记录
   * @return R
   */
  @PostMapping("/invoiceRefundRecord/add")
  public R save(@RequestBody InvoiceRefundRecord invoiceRefundRecord);

  /**
   * 修改发票退票推送记录
   * @param invoiceRefundRecord 发票退票推送记录
   * @return R
   */
  @PostMapping("/invoiceRefundRecord/update")
  public R updateById(@RequestBody InvoiceRefundRecord invoiceRefundRecord);

  /**
   * 通过id删除发票退票推送记录
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceRefundRecord/del/{id}" )
  public R removeById(@PathVariable Long id);

}