package com.xforceplus.ultraman.app.jcsunart.controller;


/**
 * 发票签收报表feign客户端
 *
 * @author ultraman
 * @date 2022-08-04
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcsunart.entity.InvoiceRefundReport;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-sunart")
public interface InvoiceRefundReportFeignApi {

  /**
   * 通过id查询发票签收报表
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceRefundReport/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票签收报表
   * @param invoiceRefundReport 发票签收报表
   * @return R
   */
  @PostMapping("/invoiceRefundReport/add")
  public R save(@RequestBody InvoiceRefundReport invoiceRefundReport);

  /**
   * 修改发票签收报表
   * @param invoiceRefundReport 发票签收报表
   * @return R
   */
  @PostMapping("/invoiceRefundReport/update")
  public R updateById(@RequestBody InvoiceRefundReport invoiceRefundReport);

  /**
   * 通过id删除发票签收报表
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceRefundReport/del/{id}" )
  public R removeById(@PathVariable Long id);

}