package com.xforceplus.ultraman.app.jcsunart.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2022-02-21
 */
public enum InvoiceType {

    S("s", "增值税专票"),
    C("c", "增值税普票"),
    F("f", "请款单"),
    D("d", "抵扣联"),
    CT("ct", "通行费"),
    O("o", "其他票据");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "c":
                return C;
            case "f":
                return F;
            case "d":
                return D;
            case "ct":
                return CT;
            case "o":
                return O;
            default:
                return null;
        }
    }
}
