package com.xforceplus.ultraman.app.jcsunart.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 区域
 * </p>
 *
 * @author ultraman
 * @since 2022-08-04
 */
public enum Region {

    HUADONG("huadong", "华东"),
    HUABEI("huabei", "华北"),
    HUANAN("huanan", "华南"),
    HUAZHONG("huazhong", "华中"),
    DONGBEI("dongbei", "东北");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Region(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Region fromCode(String code){
        switch(code) {
            case "huadong":
                return HUADONG;
            case "huabei":
                return HUABEI;
            case "huanan":
                return HUANAN;
            case "huazhong":
                return HUAZHONG;
            case "dongbei":
                return DONGBEI;
            default:
                return null;
        }
    }
}
