package com.xforceplus.ultraman.app.jcsunart.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发送状态
 * </p>
 *
 * @author ultraman
 * @since 2022-08-04
 */
public enum SendStatus {

    _0("0", "未发送"),
    _1("1", "发送成功"),
    __1("-1", "发送失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SendStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SendStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "-1":
                return __1;
            default:
                return null;
        }
    }
}
