package com.xforceplus.ultraman.app.jcsunart.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 发票签收报表
 * </p>
 *
 * @author ultraman
 * @since 2022-08-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceRefundReport implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime date;

  /**
   * 商采增专
   */
  private Long scZz;

  /**
   * 商采增普
   */
  private Long scZp;

  /**
   * 商采其他
   */
  private Long scOther;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 商采抵扣联
   */
  private Long scDkl;

  /**
   * 非商采增专
   */
  private Long fscZz;

  /**
   * 非商采增普
   */
  private Long fscZp;

  /**
   * 非商采抵扣联
   */
  private Long fscDkl;

  /**
   * 非商采通行费
   */
  private Long fscTxf;

  /**
   * 非商采其他
   */
  private Long fscQt;

  /**
   * 退票
   */
  private Long invoiceRefund;

  /**
   * 合计
   */
  private Long total;

  /**
   * 日期
   */
  private String time;

  /**
   * 区域
   */
  private String region;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("date", BocpGenUtils.toTimestamp(date));
      map.put("sc_zz", scZz);
      map.put("sc_zp", scZp);
      map.put("sc_other", scOther);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("sc_dkl", scDkl);
      map.put("fsc_zz", fscZz);
      map.put("fsc_zp", fscZp);
      map.put("fsc_dkl", fscDkl);
      map.put("fsc_txf", fscTxf);
      map.put("fsc_qt", fscQt);
      map.put("invoice_refund", invoiceRefund);
      map.put("total", total);
      map.put("time", time);
      map.put("region", region);
      return map;
  }

  public static InvoiceRefundReport fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceRefundReport entity = new InvoiceRefundReport();
    if(map.containsKey("date")) {
      Object obj = map.get("date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDate(null);
      }
    }
    if(map.containsKey("sc_zz")) {
      Object obj = map.get("sc_zz");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScZz((Long)obj);
        } else if(obj instanceof String) {
          entity.setScZz(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setScZz(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sc_zp")) {
      Object obj = map.get("sc_zp");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScZp((Long)obj);
        } else if(obj instanceof String) {
          entity.setScZp(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setScZp(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sc_other")) {
      Object obj = map.get("sc_other");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScOther((Long)obj);
        } else if(obj instanceof String) {
          entity.setScOther(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setScOther(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sc_dkl")) {
      Object obj = map.get("sc_dkl");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScDkl((Long)obj);
        } else if(obj instanceof String) {
          entity.setScDkl(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setScDkl(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("fsc_zz")) {
      Object obj = map.get("fsc_zz");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFscZz((Long)obj);
        } else if(obj instanceof String) {
          entity.setFscZz(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFscZz(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("fsc_zp")) {
      Object obj = map.get("fsc_zp");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFscZp((Long)obj);
        } else if(obj instanceof String) {
          entity.setFscZp(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFscZp(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("fsc_dkl")) {
      Object obj = map.get("fsc_dkl");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFscDkl((Long)obj);
        } else if(obj instanceof String) {
          entity.setFscDkl(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFscDkl(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("fsc_txf")) {
      Object obj = map.get("fsc_txf");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFscTxf((Long)obj);
        } else if(obj instanceof String) {
          entity.setFscTxf(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFscTxf(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("fsc_qt")) {
      Object obj = map.get("fsc_qt");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFscQt((Long)obj);
        } else if(obj instanceof String) {
          entity.setFscQt(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFscQt(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_refund")) {
      Object obj = map.get("invoice_refund");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceRefund((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceRefund(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceRefund(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("total")) {
      Object obj = map.get("total");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTotal((Long)obj);
        } else if(obj instanceof String) {
          entity.setTotal(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTotal(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("time")) {
      Object obj = map.get("time");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("region")) {
      Object obj = map.get("region");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegion((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
