package com.xforceplus.ultraman.app.jcsunart.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2022-08-04
 */
public enum InvoiceType {

    S("s", "增值税专票"),
    C("c", "增值税普票"),
    F("f", "请款单"),
    D("d", "抵扣联"),
    CT("ct", "通行费"),
    O("o", "其他票据"),
    CE("ce", "电子发票"),
    J("j", "机动车发票"),
    CJ("cj", "卷票"),
    SE("se", "电子专票"),
    CB("cb", "增值税电子普通发票（区块链）"),
    CD("cd", "浙江通用（电子）发票"),
    IM("im", "通用机打发票"),
    T("t", "火车票"),
    P("p", "飞机票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "c":
                return C;
            case "f":
                return F;
            case "d":
                return D;
            case "ct":
                return CT;
            case "o":
                return O;
            case "ce":
                return CE;
            case "j":
                return J;
            case "cj":
                return CJ;
            case "se":
                return SE;
            case "cb":
                return CB;
            case "cd":
                return CD;
            case "im":
                return IM;
            case "t":
                return T;
            case "p":
                return P;
            default:
                return null;
        }
    }
}
