package com.xforceplus.ultraman.app.jcsunart.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 退票原因
 * </p>
 *
 * @author ultraman
 * @since 2022-08-04
 */
public enum RefundReason {

    _1("1", "开票不规范"),
    _2("2", "发票无法识别"),
    _3("3", "无请款单/无订单"),
    _4("4", "无抵扣联/发票联/销货清单"),
    _5("5", "发票串号"),
    _6("6", "非华东区发票"),
    _7("7", "一审未过"),
    _8("8", "认证不通过"),
    _9("9", "异常发票"),
    _10("10", "门店要求退票"),
    _11("11", "主办要求退票"),
    _12("12", "重走流程"),
    _13("13", "其他"),
    _14("14", "无章，备注栏不符"),
    _15("15", "金额不符"),
    _16("16", "税率不符"),
    _17("17", "品项，编码不符"),
    _18("18", "折扣金额错"),
    _19("19", "国税信息未上传"),
    _20("20", "销货明细不符"),
    _21("21", "供货开票确认书不符"),
    _22("22", "开票资料不全");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RefundReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RefundReason fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            case "19":
                return _19;
            case "20":
                return _20;
            case "21":
                return _21;
            case "22":
                return _22;
            default:
                return null;
        }
    }
}
