package com.xforceplus.ultraman.app.jcsunart.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 状态
 * </p>
 *
 * @author ultraman
 * @since 2022-08-04
 */
public enum Status {

    _1("1", "正常"),
    _9("9", "删除");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Status(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Status fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
