package com.xforceplus.ultraman.app.jcsunart.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcsunart.entity.InvoiceReceipt;
import com.xforceplus.ultraman.app.jcsunart.service.IInvoiceReceiptService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-07-26
 */
@RestController
public class InvoiceReceiptController {

  @Autowired
  private IInvoiceReceiptService invoiceReceiptServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceReceipt ${table.comment}
   * @return
   */
  @GetMapping("/invoicereceipts" )
  public XfR getInvoiceReceipts(XfPage page, InvoiceReceipt invoiceReceipt) {
    return XfR.ok(invoiceReceiptServiceImpl.page(page, Wrappers.query(invoiceReceipt)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicereceipts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceReceiptServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceReceipt ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicereceipts")
  public XfR save(@RequestBody InvoiceReceipt invoiceReceipt) {
     return XfR.ok(invoiceReceiptServiceImpl.save(invoiceReceipt));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceReceipt ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicereceipts/{id}")
  public XfR putUpdate(@RequestBody InvoiceReceipt invoiceReceipt,@PathVariable Long id) {
      invoiceReceipt.setId(id);
      return XfR.ok(invoiceReceiptServiceImpl.updateById(invoiceReceipt));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceReceipt ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicereceipts/{id}")
  public XfR patchUpdate(@RequestBody InvoiceReceipt invoiceReceipt,@PathVariable Long id) {
      InvoiceReceipt upinvoiceReceipt = invoiceReceiptServiceImpl.getById(id);
      if(upinvoiceReceipt != null){
        upinvoiceReceipt = ObjectCopyUtils.copyProperties(invoiceReceipt,upinvoiceReceipt,true);
      }
      return XfR.ok(invoiceReceiptServiceImpl.updateById(upinvoiceReceipt));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicereceipts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceReceiptServiceImpl.removeById(id));
  }

  @PostMapping("/invoicereceipts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_receipt");
     params.put("request", condition);

     return XfR.ok(invoiceReceiptServiceImpl.querys(params));
  }

}
