package com.xforceplus.ultraman.app.jctenantonline.controller;


/**
 * 在线客服租户信息feign客户端
 *
 * @author ultraman
 * @date 2024-06-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctenantonline.entity.TenantInfoOnlineService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tenant-online")
public interface TenantInfoOnlineServiceFeignApi {

  /**
   * 通过id查询在线客服租户信息
   * @param  id
   * @return R
   */
  @GetMapping("/tenantInfoOnlineService/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增在线客服租户信息
   * @param tenantInfoOnlineService 在线客服租户信息
   * @return R
   */
  @PostMapping("/tenantInfoOnlineService/add")
  public R save(@RequestBody TenantInfoOnlineService tenantInfoOnlineService);

  /**
   * 修改在线客服租户信息
   * @param tenantInfoOnlineService 在线客服租户信息
   * @return R
   */
  @PostMapping("/tenantInfoOnlineService/update")
  public R updateById(@RequestBody TenantInfoOnlineService tenantInfoOnlineService);

  /**
   * 通过id删除在线客服租户信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/tenantInfoOnlineService/del/{id}" )
  public R removeById(@PathVariable Long id);

}