package com.xforceplus.ultraman.app.jctenantonline.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctenantonline.entity.TenantInfoOnlineService;
import com.xforceplus.ultraman.app.jctenantonline.service.ITenantInfoOnlineServiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 在线客服租户信息前端控制器
 *
 * @author ultraman
 * @date 2024-06-03
 */
@RestController
public class TenantInfoOnlineServiceController {

  @Autowired
  private ITenantInfoOnlineServiceService tenantInfoOnlineServiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tenantInfoOnlineService 在线客服租户信息
   * @return
   */
  @GetMapping("/tenantinfoonlineservices" )
  public XfR getTenantInfoOnlineServices(XfPage page, TenantInfoOnlineService tenantInfoOnlineService) {
    return XfR.ok(tenantInfoOnlineServiceServiceImpl.page(page, Wrappers.query(tenantInfoOnlineService)));
  }

  /**
   * 通过id查询在线客服租户信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/tenantinfoonlineservices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tenantInfoOnlineServiceServiceImpl.getById(id));
  }

  /**
   * 新增在线客服租户信息
   * @param tenantInfoOnlineService 在线客服租户信息
   * @return XfR
   */
  @PostMapping("/tenantinfoonlineservices")
  public XfR save(@RequestBody TenantInfoOnlineService tenantInfoOnlineService) {
     return XfR.ok(tenantInfoOnlineServiceServiceImpl.save(tenantInfoOnlineService));
  }

  /**
   * 修改-传入修改后的全部数据在线客服租户信息
   * @param tenantInfoOnlineService 在线客服租户信息
   * @return XfR
   */
  @PutMapping("/tenantinfoonlineservices/{id}")
  public XfR putUpdate(@RequestBody TenantInfoOnlineService tenantInfoOnlineService,@PathVariable Long id) {
      tenantInfoOnlineService.setId(id);
      return XfR.ok(tenantInfoOnlineServiceServiceImpl.updateById(tenantInfoOnlineService));
  }

  /**
   * 修改-传入修改的数据在线客服租户信息
   * @param tenantInfoOnlineService 在线客服租户信息
   * @return XfR
   */
  @PatchMapping("/tenantinfoonlineservices/{id}")
  public XfR patchUpdate(@RequestBody TenantInfoOnlineService tenantInfoOnlineService,@PathVariable Long id) {
      TenantInfoOnlineService uptenantInfoOnlineService = tenantInfoOnlineServiceServiceImpl.getById(id);
      if(uptenantInfoOnlineService != null){
        uptenantInfoOnlineService = ObjectCopyUtils.copyProperties(tenantInfoOnlineService,uptenantInfoOnlineService,true);
      }
      return XfR.ok(tenantInfoOnlineServiceServiceImpl.updateById(uptenantInfoOnlineService));
  }

  /**
   * 通过id删除在线客服租户信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tenantinfoonlineservices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tenantInfoOnlineServiceServiceImpl.removeById(id));
  }

  @PostMapping("/tenantinfoonlineservices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tenant_info_online_service");
     params.put("request", condition);

     return XfR.ok(tenantInfoOnlineServiceServiceImpl.querys(params));
  }

}
