package com.xforceplus.ultraman.app.jctke.controller;


/**
 * 付款管理与采购单关系表feign客户端
 *
 * @author ultraman
 * @date 2022-06-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.PoAndPaymentManageldRelation;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface PoAndPaymentManageldRelationFeignApi {

  /**
   * 通过id查询付款管理与采购单关系表
   * @param  id
   * @return R
   */
  @GetMapping("/poAndPaymentManageldRelation/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增付款管理与采购单关系表
   * @param poAndPaymentManageldRelation 付款管理与采购单关系表
   * @return R
   */
  @PostMapping("/poAndPaymentManageldRelation/add")
  public R save(@RequestBody PoAndPaymentManageldRelation poAndPaymentManageldRelation);

  /**
   * 修改付款管理与采购单关系表
   * @param poAndPaymentManageldRelation 付款管理与采购单关系表
   * @return R
   */
  @PostMapping("/poAndPaymentManageldRelation/update")
  public R updateById(@RequestBody PoAndPaymentManageldRelation poAndPaymentManageldRelation);

  /**
   * 通过id删除付款管理与采购单关系表
   * @param  id
   * @return R
   */
  @DeleteMapping("/poAndPaymentManageldRelation/del/{id}" )
  public R removeById(@PathVariable Long id);

}