package com.xforceplus.ultraman.app.jctke.controller;


/**
 * 无po单预付单feign客户端
 *
 * @author ultraman
 * @date 2022-04-06
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.NoPoImprest;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface NoPoImprestFeignApi {

  /**
   * 通过id查询无po单预付单
   * @param  id
   * @return R
   */
  @GetMapping("/noPoImprest/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增无po单预付单
   * @param noPoImprest 无po单预付单
   * @return R
   */
  @PostMapping("/noPoImprest/add")
  public R save(@RequestBody NoPoImprest noPoImprest);

  /**
   * 修改无po单预付单
   * @param noPoImprest 无po单预付单
   * @return R
   */
  @PostMapping("/noPoImprest/update")
  public R updateById(@RequestBody NoPoImprest noPoImprest);

  /**
   * 通过id删除无po单预付单
   * @param  id
   * @return R
   */
  @DeleteMapping("/noPoImprest/del/{id}" )
  public R removeById(@PathVariable Long id);

}