package com.xforceplus.ultraman.app.jctke.controller;


/**
 * 收货单明细feign客户端
 *
 * @author ultraman
 * @date 2022-07-20
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.GoodsReceiptItem;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface GoodsReceiptItemFeignApi {

  /**
   * 通过id查询收货单明细
   * @param  id
   * @return R
   */
  @GetMapping("/goodsReceiptItem/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增收货单明细
   * @param goodsReceiptItem 收货单明细
   * @return R
   */
  @PostMapping("/goodsReceiptItem/add")
  public R save(@RequestBody GoodsReceiptItem goodsReceiptItem);

  /**
   * 修改收货单明细
   * @param goodsReceiptItem 收货单明细
   * @return R
   */
  @PostMapping("/goodsReceiptItem/update")
  public R updateById(@RequestBody GoodsReceiptItem goodsReceiptItem);

  /**
   * 通过id删除收货单明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/goodsReceiptItem/del/{id}" )
  public R removeById(@PathVariable Long id);

}