package com.xforceplus.ultraman.app.jctke.controller;


/**
 * Rpa任务回执feign客户端
 *
 * @author ultraman
 * @date 2022-10-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.RpaResponse;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface RpaResponseFeignApi {

  /**
   * 通过id查询Rpa任务回执
   * @param  id
   * @return R
   */
  @GetMapping("/rpaResponse/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增Rpa任务回执
   * @param rpaResponse Rpa任务回执
   * @return R
   */
  @PostMapping("/rpaResponse/add")
  public R save(@RequestBody RpaResponse rpaResponse);

  /**
   * 修改Rpa任务回执
   * @param rpaResponse Rpa任务回执
   * @return R
   */
  @PostMapping("/rpaResponse/update")
  public R updateById(@RequestBody RpaResponse rpaResponse);

  /**
   * 通过id删除Rpa任务回执
   * @param  id
   * @return R
   */
  @DeleteMapping("/rpaResponse/del/{id}" )
  public R removeById(@PathVariable Long id);

}