package com.xforceplus.ultraman.app.jctke.controller;


/**
 * 外键为预付单id，用于聚合已核销金额feign客户端
 *
 * @author ultraman
 * @date 2023-03-03
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.PrepaymentWriteRelation;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface PrepaymentWriteRelationFeignApi {

  /**
   * 通过id查询外键为预付单id，用于聚合已核销金额
   * @param  id
   * @return R
   */
  @GetMapping("/prepaymentWriteRelation/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增外键为预付单id，用于聚合已核销金额
   * @param prepaymentWriteRelation 外键为预付单id，用于聚合已核销金额
   * @return R
   */
  @PostMapping("/prepaymentWriteRelation/add")
  public R save(@RequestBody PrepaymentWriteRelation prepaymentWriteRelation);

  /**
   * 修改外键为预付单id，用于聚合已核销金额
   * @param prepaymentWriteRelation 外键为预付单id，用于聚合已核销金额
   * @return R
   */
  @PostMapping("/prepaymentWriteRelation/update")
  public R updateById(@RequestBody PrepaymentWriteRelation prepaymentWriteRelation);

  /**
   * 通过id删除外键为预付单id，用于聚合已核销金额
   * @param  id
   * @return R
   */
  @DeleteMapping("/prepaymentWriteRelation/del/{id}" )
  public R removeById(@PathVariable Long id);

}