package com.xforceplus.ultraman.app.jctke.controller;


/**
 * 申请Idfeign客户端
 *
 * @author ultraman
 * @date 2023-04-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.ApplyId;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface ApplyIdFeignApi {

  /**
   * 通过id查询申请Id
   * @param  id
   * @return R
   */
  @GetMapping("/applyId/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增申请Id
   * @param applyId 申请Id
   * @return R
   */
  @PostMapping("/applyId/add")
  public R save(@RequestBody ApplyId applyId);

  /**
   * 修改申请Id
   * @param applyId 申请Id
   * @return R
   */
  @PostMapping("/applyId/update")
  public R updateById(@RequestBody ApplyId applyId);

  /**
   * 通过id删除申请Id
   * @param  id
   * @return R
   */
  @DeleteMapping("/applyId/del/{id}" )
  public R removeById(@PathVariable Long id);

}