package com.xforceplus.ultraman.app.jctke.controller;


/**
 * 付款申请ID生成器feign客户端
 *
 * @author ultraman
 * @date 2024-02-29
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.ApplyId;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface ApplyIdFeignApi {

  /**
   * 通过id查询付款申请ID生成器
   * @param  id
   * @return R
   */
  @GetMapping("/applyId/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增付款申请ID生成器
   * @param applyId 付款申请ID生成器
   * @return R
   */
  @PostMapping("/applyId/add")
  public R save(@RequestBody ApplyId applyId);

  /**
   * 修改付款申请ID生成器
   * @param applyId 付款申请ID生成器
   * @return R
   */
  @PostMapping("/applyId/update")
  public R updateById(@RequestBody ApplyId applyId);

  /**
   * 通过id删除付款申请ID生成器
   * @param  id
   * @return R
   */
  @DeleteMapping("/applyId/del/{id}" )
  public R removeById(@PathVariable Long id);

}