package com.xforceplus.ultraman.app.jctke.controller;


/**
 * 结算单主信息feign客户端
 *
 * @author ultraman
 * @date 2024-02-29
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.Settlement;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface SettlementFeignApi {

  /**
   * 通过id查询结算单主信息
   * @param  id
   * @return R
   */
  @GetMapping("/settlement/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增结算单主信息
   * @param settlement 结算单主信息
   * @return R
   */
  @PostMapping("/settlement/add")
  public R save(@RequestBody Settlement settlement);

  /**
   * 修改结算单主信息
   * @param settlement 结算单主信息
   * @return R
   */
  @PostMapping("/settlement/update")
  public R updateById(@RequestBody Settlement settlement);

  /**
   * 通过id删除结算单主信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/settlement/del/{id}" )
  public R removeById(@PathVariable Long id);

}