package com.xforceplus.ultraman.app.jctke.controller;


/**
 * 预付单feign客户端
 *
 * @author ultraman
 * @date 2024-07-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.Imprest;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface ImprestFeignApi {

  /**
   * 通过id查询预付单
   * @param  id
   * @return R
   */
  @GetMapping("/imprest/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增预付单
   * @param imprest 预付单
   * @return R
   */
  @PostMapping("/imprest/add")
  public R save(@RequestBody Imprest imprest);

  /**
   * 修改预付单
   * @param imprest 预付单
   * @return R
   */
  @PostMapping("/imprest/update")
  public R updateById(@RequestBody Imprest imprest);

  /**
   * 通过id删除预付单
   * @param  id
   * @return R
   */
  @DeleteMapping("/imprest/del/{id}" )
  public R removeById(@PathVariable Long id);

}